/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisFirehoseConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisFirehoseConfig> {
    private static final SdkField<String> FIREHOSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirehoseArn").getter(KinesisFirehoseConfig.getter(KinesisFirehoseConfig::firehoseArn)).setter(KinesisFirehoseConfig.setter(Builder::firehoseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREHOSE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String firehoseArn;

    private KinesisFirehoseConfig(BuilderImpl builder) {
        this.firehoseArn = builder.firehoseArn;
    }

    public final String firehoseArn() {
        return this.firehoseArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firehoseArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseConfig)) {
            return false;
        }
        KinesisFirehoseConfig other = (KinesisFirehoseConfig)obj;
        return Objects.equals(this.firehoseArn(), other.firehoseArn());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisFirehoseConfig").add("FirehoseArn", (Object)this.firehoseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirehoseArn": {
                return Optional.ofNullable(clazz.cast(this.firehoseArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisFirehoseConfig, T> g) {
        return obj -> g.apply((KinesisFirehoseConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String firehoseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseConfig model) {
            this.firehoseArn(model.firehoseArn);
        }

        public final String getFirehoseArn() {
            return this.firehoseArn;
        }

        @Override
        public final Builder firehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
            return this;
        }

        public final void setFirehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
        }

        public KinesisFirehoseConfig build() {
            return new KinesisFirehoseConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisFirehoseConfig> {
        public Builder firehoseArn(String var1);
    }
}

