/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.LexBot;
import software.amazon.awssdk.services.connect.model.LexBotsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLexBotsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListLexBotsResponse> {
    private static final SdkField<List<LexBot>> LEX_BOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LexBots").getter(ListLexBotsResponse.getter(ListLexBotsResponse::lexBots)).setter(ListLexBotsResponse.setter(Builder::lexBots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LexBot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLexBotsResponse.getter(ListLexBotsResponse::nextToken)).setter(ListLexBotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEX_BOTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LexBot> lexBots;
    private final String nextToken;

    private ListLexBotsResponse(BuilderImpl builder) {
        super(builder);
        this.lexBots = builder.lexBots;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLexBots() {
        return this.lexBots != null && !(this.lexBots instanceof SdkAutoConstructList);
    }

    public List<LexBot> lexBots() {
        return this.lexBots;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLexBots() ? this.lexBots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLexBotsResponse)) {
            return false;
        }
        ListLexBotsResponse other = (ListLexBotsResponse)((Object)obj);
        return this.hasLexBots() == other.hasLexBots() && Objects.equals(this.lexBots(), other.lexBots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListLexBotsResponse").add("LexBots", this.hasLexBots() ? this.lexBots() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LexBots": {
                return Optional.ofNullable(clazz.cast(this.lexBots()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLexBotsResponse, T> g) {
        return obj -> g.apply((ListLexBotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<LexBot> lexBots = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLexBotsResponse model) {
            super(model);
            this.lexBots(model.lexBots);
            this.nextToken(model.nextToken);
        }

        public final Collection<LexBot.Builder> getLexBots() {
            if (this.lexBots instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lexBots != null ? (Collection)this.lexBots.stream().map(LexBot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lexBots(Collection<LexBot> lexBots) {
            this.lexBots = LexBotsListCopier.copy(lexBots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexBots(LexBot ... lexBots) {
            this.lexBots(Arrays.asList(lexBots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexBots(Consumer<LexBot.Builder> ... lexBots) {
            this.lexBots(Stream.of(lexBots).map(c -> (LexBot)((LexBot.Builder)LexBot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLexBots(Collection<LexBot.BuilderImpl> lexBots) {
            this.lexBots = LexBotsListCopier.copyFromBuilder(lexBots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLexBotsResponse build() {
            return new ListLexBotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLexBotsResponse> {
        public Builder lexBots(Collection<LexBot> var1);

        public Builder lexBots(LexBot ... var1);

        public Builder lexBots(Consumer<LexBot.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

