/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartChatContactResponse extends ConnectResponse implements
        ToCopyableBuilder<StartChatContactResponse.Builder, StartChatContactResponse> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChatContactResponse::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChatContactResponse::participantId)).setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final SdkField<String> PARTICIPANT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChatContactResponse::participantToken)).setter(setter(Builder::participantToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            PARTICIPANT_ID_FIELD, PARTICIPANT_TOKEN_FIELD));

    private final String contactId;

    private final String participantId;

    private final String participantToken;

    private StartChatContactResponse(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.participantId = builder.participantId;
        this.participantToken = builder.participantToken;
    }

    /**
     * <p>
     * The identifier of this contact within the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of this contact within the Amazon Connect instance.
     */
    public String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The identifier for a chat participant. The participantId for a chat participant is the same throughout the chat
     * lifecycle.
     * </p>
     * 
     * @return The identifier for a chat participant. The participantId for a chat participant is the same throughout
     *         the chat lifecycle.
     */
    public String participantId() {
        return participantId;
    }

    /**
     * <p>
     * The token used by the chat participant to call <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     * >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.
     * </p>
     * 
     * @return The token used by the chat participant to call <a
     *         href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     *         >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.
     */
    public String participantToken() {
        return participantToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(participantToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChatContactResponse)) {
            return false;
        }
        StartChatContactResponse other = (StartChatContactResponse) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(participantToken(), other.participantToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartChatContactResponse").add("ContactId", contactId()).add("ParticipantId", participantId())
                .add("ParticipantToken", participantToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "ParticipantToken":
            return Optional.ofNullable(clazz.cast(participantToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChatContactResponse, T> g) {
        return obj -> g.apply((StartChatContactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartChatContactResponse> {
        /**
         * <p>
         * The identifier of this contact within the Amazon Connect instance.
         * </p>
         * 
         * @param contactId
         *        The identifier of this contact within the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The identifier for a chat participant. The participantId for a chat participant is the same throughout the
         * chat lifecycle.
         * </p>
         * 
         * @param participantId
         *        The identifier for a chat participant. The participantId for a chat participant is the same throughout
         *        the chat lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * The token used by the chat participant to call <a href=
         * "https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
         * >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.
         * </p>
         * 
         * @param participantToken
         *        The token used by the chat participant to call <a href=
         *        "https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
         *        >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat
         *        participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantToken(String participantToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String contactId;

        private String participantId;

        private String participantToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChatContactResponse model) {
            super(model);
            contactId(model.contactId);
            participantId(model.participantId);
            participantToken(model.participantToken);
        }

        public final String getContactId() {
            return contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        public final String getParticipantId() {
            return participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        public final String getParticipantToken() {
            return participantToken;
        }

        @Override
        public final Builder participantToken(String participantToken) {
            this.participantToken = participantToken;
            return this;
        }

        public final void setParticipantToken(String participantToken) {
            this.participantToken = participantToken;
        }

        @Override
        public StartChatContactResponse build() {
            return new StartChatContactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
