/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserHierarchyGroupRequest extends ConnectRequest implements
        ToCopyableBuilder<DescribeUserHierarchyGroupRequest.Builder, DescribeUserHierarchyGroupRequest> {
    private static final SdkField<String> HIERARCHY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUserHierarchyGroupRequest::hierarchyGroupId)).setter(setter(Builder::hierarchyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("HierarchyGroupId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUserHierarchyGroupRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIERARCHY_GROUP_ID_FIELD,
            INSTANCE_ID_FIELD));

    private final String hierarchyGroupId;

    private final String instanceId;

    private DescribeUserHierarchyGroupRequest(BuilderImpl builder) {
        super(builder);
        this.hierarchyGroupId = builder.hierarchyGroupId;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The identifier of the hierarchy group.
     * </p>
     * 
     * @return The identifier of the hierarchy group.
     */
    public String hierarchyGroupId() {
        return hierarchyGroupId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserHierarchyGroupRequest)) {
            return false;
        }
        DescribeUserHierarchyGroupRequest other = (DescribeUserHierarchyGroupRequest) obj;
        return Objects.equals(hierarchyGroupId(), other.hierarchyGroupId()) && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUserHierarchyGroupRequest").add("HierarchyGroupId", hierarchyGroupId())
                .add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HierarchyGroupId":
            return Optional.ofNullable(clazz.cast(hierarchyGroupId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserHierarchyGroupRequest, T> g) {
        return obj -> g.apply((DescribeUserHierarchyGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserHierarchyGroupRequest> {
        /**
         * <p>
         * The identifier of the hierarchy group.
         * </p>
         * 
         * @param hierarchyGroupId
         *        The identifier of the hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyGroupId(String hierarchyGroupId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String hierarchyGroupId;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserHierarchyGroupRequest model) {
            super(model);
            hierarchyGroupId(model.hierarchyGroupId);
            instanceId(model.instanceId);
        }

        public final String getHierarchyGroupId() {
            return hierarchyGroupId;
        }

        @Override
        public final Builder hierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
            return this;
        }

        public final void setHierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUserHierarchyGroupRequest build() {
            return new DescribeUserHierarchyGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
