/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.HistoricalMetricName;
import software.amazon.awssdk.services.connect.model.Statistic;
import software.amazon.awssdk.services.connect.model.Threshold;
import software.amazon.awssdk.services.connect.model.Unit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HistoricalMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HistoricalMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HistoricalMetric.getter(HistoricalMetric::nameAsString)).setter(HistoricalMetric.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Threshold> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoricalMetric.getter(HistoricalMetric::threshold)).setter(HistoricalMetric.setter(Builder::threshold)).constructor(Threshold::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HistoricalMetric.getter(HistoricalMetric::statisticAsString)).setter(HistoricalMetric.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HistoricalMetric.getter(HistoricalMetric::unitAsString)).setter(HistoricalMetric.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, THRESHOLD_FIELD, STATISTIC_FIELD, UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Threshold threshold;
    private final String statistic;
    private final String unit;

    private HistoricalMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.threshold = builder.threshold;
        this.statistic = builder.statistic;
        this.unit = builder.unit;
    }

    public HistoricalMetricName name() {
        return HistoricalMetricName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public Threshold threshold() {
        return this.threshold;
    }

    public Statistic statistic() {
        return Statistic.fromValue(this.statistic);
    }

    public String statisticAsString() {
        return this.statistic;
    }

    public Unit unit() {
        return Unit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoricalMetric)) {
            return false;
        }
        HistoricalMetric other = (HistoricalMetric)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public String toString() {
        return ToString.builder((String)"HistoricalMetric").add("Name", (Object)this.nameAsString()).add("Threshold", (Object)this.threshold()).add("Statistic", (Object)this.statisticAsString()).add("Unit", (Object)this.unitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HistoricalMetric, T> g) {
        return obj -> g.apply((HistoricalMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Threshold threshold;
        private String statistic;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoricalMetric model) {
            this.name(model.name);
            this.threshold(model.threshold);
            this.statistic(model.statistic);
            this.unit(model.unit);
        }

        public final String getNameAsString() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(HistoricalMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Threshold.Builder getThreshold() {
            return this.threshold != null ? this.threshold.toBuilder() : null;
        }

        @Override
        public final Builder threshold(Threshold threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Threshold.BuilderImpl threshold) {
            this.threshold = threshold != null ? threshold.build() : null;
        }

        public final String getStatisticAsString() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final String getUnitAsString() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public HistoricalMetric build() {
            return new HistoricalMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HistoricalMetric> {
        public Builder name(String var1);

        public Builder name(HistoricalMetricName var1);

        public Builder threshold(Threshold var1);

        default public Builder threshold(Consumer<Threshold.Builder> threshold) {
            return this.threshold((Threshold)((Threshold.Builder)Threshold.builder().applyMutation(threshold)).build());
        }

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder unit(String var1);

        public Builder unit(Unit var1);
    }
}

