/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the source and the message types that trigger Config to evaluate your Amazon Web Services resources against
 * a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type
 * is periodic. You can specify the parameter values for <code>SourceDetail</code> only for custom rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDetail implements SdkPojo, Serializable, ToCopyableBuilder<SourceDetail.Builder, SourceDetail> {
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSource").getter(getter(SourceDetail::eventSourceAsString)).setter(setter(Builder::eventSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(SourceDetail::messageTypeAsString)).setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<String> MAXIMUM_EXECUTION_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaximumExecutionFrequency").getter(getter(SourceDetail::maximumExecutionFrequencyAsString))
            .setter(setter(Builder::maximumExecutionFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionFrequency").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_FIELD,
            MESSAGE_TYPE_FIELD, MAXIMUM_EXECUTION_FREQUENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventSource;

    private final String messageType;

    private final String maximumExecutionFrequency;

    private SourceDetail(BuilderImpl builder) {
        this.eventSource = builder.eventSource;
        this.messageType = builder.messageType;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
    }

    /**
     * <p>
     * The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon Web
     * Services resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSource} will
     * return {@link EventSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventSourceAsString}.
     * </p>
     * 
     * @return The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your
     *         Amazon Web Services resources.
     * @see EventSource
     */
    public final EventSource eventSource() {
        return EventSource.fromValue(eventSource);
    }

    /**
     * <p>
     * The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon Web
     * Services resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSource} will
     * return {@link EventSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventSourceAsString}.
     * </p>
     * 
     * @return The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your
     *         Amazon Web Services resources.
     * @see EventSource
     */
    public final String eventSourceAsString() {
        return eventSource;
    }

    /**
     * <p>
     * The type of notification that triggers Config to run an evaluation for a rule. You can specify the following
     * notification types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration
     * item as a result of a resource change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an
     * oversized configuration item. Config may generate this notification type when a resource changes and the
     * notification exceeds the maximum size allowed by Amazon SNS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
     * <code>MaximumExecutionFrequency</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a
     * configuration snapshot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for
     * <code>ConfigurationItemChangeNotification</code> and one for
     * <code>OversizedConfigurationItemChangeNotification</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of notification that triggers Config to run an evaluation for a rule. You can specify the
     *         following notification types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a
     *         configuration item as a result of a resource change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers
     *         an oversized configuration item. Config may generate this notification type when a resource changes and
     *         the notification exceeds the maximum size allowed by Amazon SNS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
     *         <code>MaximumExecutionFrequency</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers
     *         a configuration snapshot.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects,
     *         one for <code>ConfigurationItemChangeNotification</code> and one for
     *         <code>OversizedConfigurationItemChangeNotification</code>.
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The type of notification that triggers Config to run an evaluation for a rule. You can specify the following
     * notification types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration
     * item as a result of a resource change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an
     * oversized configuration item. Config may generate this notification type when a resource changes and the
     * notification exceeds the maximum size allowed by Amazon SNS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
     * <code>MaximumExecutionFrequency</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a
     * configuration snapshot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for
     * <code>ConfigurationItemChangeNotification</code> and one for
     * <code>OversizedConfigurationItemChangeNotification</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of notification that triggers Config to run an evaluation for a rule. You can specify the
     *         following notification types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a
     *         configuration item as a result of a resource change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers
     *         an oversized configuration item. Config may generate this notification type when a resource changes and
     *         the notification exceeds the maximum size allowed by Amazon SNS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
     *         <code>MaximumExecutionFrequency</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers
     *         a configuration snapshot.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects,
     *         one for <code>ConfigurationItemChangeNotification</code> and one for
     *         <code>OversizedConfigurationItemChangeNotification</code>.
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you
     * specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the
     * <code>ScheduledNotification</code> value.
     * </p>
     * <note>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
     * value for the <code>MaximumExecutionFrequency</code> parameter.
     * </p>
     * <p>
     * Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you
     * choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case,
     * <code>Three_Hours</code> is the frequency of this rule.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumExecutionFrequency} will return {@link MaximumExecutionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumExecutionFrequencyAsString}.
     * </p>
     * 
     * @return The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If
     *         you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use
     *         the <code>ScheduledNotification</code> value.</p> <note>
     *         <p>
     *         By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify
     *         a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     *         </p>
     *         <p>
     *         Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if
     *         you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case,
     *         <code>Three_Hours</code> is the frequency of this rule.
     *         </p>
     * @see MaximumExecutionFrequency
     */
    public final MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(maximumExecutionFrequency);
    }

    /**
     * <p>
     * The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you
     * specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the
     * <code>ScheduledNotification</code> value.
     * </p>
     * <note>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
     * value for the <code>MaximumExecutionFrequency</code> parameter.
     * </p>
     * <p>
     * Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you
     * choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case,
     * <code>Three_Hours</code> is the frequency of this rule.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumExecutionFrequency} will return {@link MaximumExecutionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumExecutionFrequencyAsString}.
     * </p>
     * 
     * @return The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If
     *         you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use
     *         the <code>ScheduledNotification</code> value.</p> <note>
     *         <p>
     *         By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify
     *         a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     *         </p>
     *         <p>
     *         Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if
     *         you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case,
     *         <code>Three_Hours</code> is the frequency of this rule.
     *         </p>
     * @see MaximumExecutionFrequency
     */
    public final String maximumExecutionFrequencyAsString() {
        return maximumExecutionFrequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumExecutionFrequencyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDetail)) {
            return false;
        }
        SourceDetail other = (SourceDetail) obj;
        return Objects.equals(eventSourceAsString(), other.eventSourceAsString())
                && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && Objects.equals(maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceDetail").add("EventSource", eventSourceAsString())
                .add("MessageType", messageTypeAsString()).add("MaximumExecutionFrequency", maximumExecutionFrequencyAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSource":
            return Optional.ofNullable(clazz.cast(eventSourceAsString()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "MaximumExecutionFrequency":
            return Optional.ofNullable(clazz.cast(maximumExecutionFrequencyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventSource", EVENT_SOURCE_FIELD);
        map.put("MessageType", MESSAGE_TYPE_FIELD);
        map.put("MaximumExecutionFrequency", MAXIMUM_EXECUTION_FREQUENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDetail, T> g) {
        return obj -> g.apply((SourceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDetail> {
        /**
         * <p>
         * The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon
         * Web Services resources.
         * </p>
         * 
         * @param eventSource
         *        The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your
         *        Amazon Web Services resources.
         * @see EventSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSource
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon
         * Web Services resources.
         * </p>
         * 
         * @param eventSource
         *        The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your
         *        Amazon Web Services resources.
         * @see EventSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSource
         */
        Builder eventSource(EventSource eventSource);

        /**
         * <p>
         * The type of notification that triggers Config to run an evaluation for a rule. You can specify the following
         * notification types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a
         * configuration item as a result of a resource change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an
         * oversized configuration item. Config may generate this notification type when a resource changes and the
         * notification exceeds the maximum size allowed by Amazon SNS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
         * <code>MaximumExecutionFrequency</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a
         * configuration snapshot.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one
         * for <code>ConfigurationItemChangeNotification</code> and one for
         * <code>OversizedConfigurationItemChangeNotification</code>.
         * </p>
         * 
         * @param messageType
         *        The type of notification that triggers Config to run an evaluation for a rule. You can specify the
         *        following notification types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a
         *        configuration item as a result of a resource change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config
         *        delivers an oversized configuration item. Config may generate this notification type when a resource
         *        changes and the notification exceeds the maximum size allowed by Amazon SNS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
         *        <code>MaximumExecutionFrequency</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config
         *        delivers a configuration snapshot.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you want your custom rule to be triggered by configuration changes, specify two SourceDetail
         *        objects, one for <code>ConfigurationItemChangeNotification</code> and one for
         *        <code>OversizedConfigurationItemChangeNotification</code>.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The type of notification that triggers Config to run an evaluation for a rule. You can specify the following
         * notification types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a
         * configuration item as a result of a resource change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an
         * oversized configuration item. Config may generate this notification type when a resource changes and the
         * notification exceeds the maximum size allowed by Amazon SNS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
         * <code>MaximumExecutionFrequency</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a
         * configuration snapshot.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one
         * for <code>ConfigurationItemChangeNotification</code> and one for
         * <code>OversizedConfigurationItemChangeNotification</code>.
         * </p>
         * 
         * @param messageType
         *        The type of notification that triggers Config to run an evaluation for a rule. You can specify the
         *        following notification types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a
         *        configuration item as a result of a resource change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config
         *        delivers an oversized configuration item. Config may generate this notification type when a resource
         *        changes and the notification exceeds the maximum size allowed by Amazon SNS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
         *        <code>MaximumExecutionFrequency</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config
         *        delivers a configuration snapshot.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you want your custom rule to be triggered by configuration changes, specify two SourceDetail
         *        objects, one for <code>ConfigurationItemChangeNotification</code> and one for
         *        <code>OversizedConfigurationItemChangeNotification</code>.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you
         * specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the
         * <code>ScheduledNotification</code> value.
         * </p>
         * <note>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a
         * valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * </p>
         * <p>
         * Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you
         * choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case,
         * <code>Three_Hours</code> is the frequency of this rule.
         * </p>
         * </note>
         * 
         * @param maximumExecutionFrequency
         *        The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger.
         *        If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must
         *        use the <code>ScheduledNotification</code> value.</p> <note>
         *        <p>
         *        By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency,
         *        specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         *        </p>
         *        <p>
         *        Based on the valid value you choose, Config runs evaluations once for each valid value. For example,
         *        if you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case,
         *        <code>Three_Hours</code> is the frequency of this rule.
         *        </p>
         * @see MaximumExecutionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumExecutionFrequency
         */
        Builder maximumExecutionFrequency(String maximumExecutionFrequency);

        /**
         * <p>
         * The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you
         * specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the
         * <code>ScheduledNotification</code> value.
         * </p>
         * <note>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a
         * valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * </p>
         * <p>
         * Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you
         * choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case,
         * <code>Three_Hours</code> is the frequency of this rule.
         * </p>
         * </note>
         * 
         * @param maximumExecutionFrequency
         *        The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger.
         *        If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must
         *        use the <code>ScheduledNotification</code> value.</p> <note>
         *        <p>
         *        By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency,
         *        specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         *        </p>
         *        <p>
         *        Based on the valid value you choose, Config runs evaluations once for each valid value. For example,
         *        if you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case,
         *        <code>Three_Hours</code> is the frequency of this rule.
         *        </p>
         * @see MaximumExecutionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumExecutionFrequency
         */
        Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency);
    }

    static final class BuilderImpl implements Builder {
        private String eventSource;

        private String messageType;

        private String maximumExecutionFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDetail model) {
            eventSource(model.eventSource);
            messageType(model.messageType);
            maximumExecutionFrequency(model.maximumExecutionFrequency);
        }

        public final String getEventSource() {
            return eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        @Override
        public final Builder eventSource(EventSource eventSource) {
            this.eventSource(eventSource == null ? null : eventSource.toString());
            return this;
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final String getMaximumExecutionFrequency() {
            return maximumExecutionFrequency;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency == null ? null : maximumExecutionFrequency.toString());
            return this;
        }

        @Override
        public SourceDetail build() {
            return new SourceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
