/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEvaluationsResponse extends ConfigResponse implements
        ToCopyableBuilder<PutEvaluationsResponse.Builder, PutEvaluationsResponse> {
    private static final SdkField<List<Evaluation>> FAILED_EVALUATIONS_FIELD = SdkField
            .<List<Evaluation>> builder(MarshallingType.LIST)
            .memberName("FailedEvaluations")
            .getter(getter(PutEvaluationsResponse::failedEvaluations))
            .setter(setter(Builder::failedEvaluations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEvaluations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Evaluation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Evaluation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_EVALUATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Evaluation> failedEvaluations;

    private PutEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEvaluations = builder.failedEvaluations;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedEvaluations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedEvaluations() {
        return failedEvaluations != null && !(failedEvaluations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Requests that failed because of a client or server error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedEvaluations} method.
     * </p>
     * 
     * @return Requests that failed because of a client or server error.
     */
    public final List<Evaluation> failedEvaluations() {
        return failedEvaluations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedEvaluations() ? failedEvaluations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsResponse)) {
            return false;
        }
        PutEvaluationsResponse other = (PutEvaluationsResponse) obj;
        return hasFailedEvaluations() == other.hasFailedEvaluations()
                && Objects.equals(failedEvaluations(), other.failedEvaluations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEvaluationsResponse")
                .add("FailedEvaluations", hasFailedEvaluations() ? failedEvaluations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedEvaluations":
            return Optional.ofNullable(clazz.cast(failedEvaluations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FailedEvaluations", FAILED_EVALUATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEvaluationsResponse, T> g) {
        return obj -> g.apply((PutEvaluationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutEvaluationsResponse> {
        /**
         * <p>
         * Requests that failed because of a client or server error.
         * </p>
         * 
         * @param failedEvaluations
         *        Requests that failed because of a client or server error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEvaluations(Collection<Evaluation> failedEvaluations);

        /**
         * <p>
         * Requests that failed because of a client or server error.
         * </p>
         * 
         * @param failedEvaluations
         *        Requests that failed because of a client or server error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEvaluations(Evaluation... failedEvaluations);

        /**
         * <p>
         * Requests that failed because of a client or server error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.Evaluation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.config.model.Evaluation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.Evaluation.Builder#build()} is called immediately and its
         * result is passed to {@link #failedEvaluations(List<Evaluation>)}.
         * 
         * @param failedEvaluations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.Evaluation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedEvaluations(java.util.Collection<Evaluation>)
         */
        Builder failedEvaluations(Consumer<Evaluation.Builder>... failedEvaluations);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<Evaluation> failedEvaluations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEvaluationsResponse model) {
            super(model);
            failedEvaluations(model.failedEvaluations);
        }

        public final List<Evaluation.Builder> getFailedEvaluations() {
            List<Evaluation.Builder> result = EvaluationsCopier.copyToBuilder(this.failedEvaluations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedEvaluations(Collection<Evaluation.BuilderImpl> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copyFromBuilder(failedEvaluations);
        }

        @Override
        public final Builder failedEvaluations(Collection<Evaluation> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copy(failedEvaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEvaluations(Evaluation... failedEvaluations) {
            failedEvaluations(Arrays.asList(failedEvaluations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEvaluations(Consumer<Evaluation.Builder>... failedEvaluations) {
            failedEvaluations(Stream.of(failedEvaluations).map(c -> Evaluation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutEvaluationsResponse build() {
            return new PutEvaluationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
