/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use EvaluationContext to group independently initiated proactive resource evaluations. For example, CFN Stack. If you
 * want to check just a resource definition, you do not need to provide evaluation context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationContext implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationContext.Builder, EvaluationContext> {
    private static final SdkField<String> EVALUATION_CONTEXT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EvaluationContextIdentifier")
            .getter(getter(EvaluationContext::evaluationContextIdentifier))
            .setter(setter(Builder::evaluationContextIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContextIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVALUATION_CONTEXT_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String evaluationContextIdentifier;

    private EvaluationContext(BuilderImpl builder) {
        this.evaluationContextIdentifier = builder.evaluationContextIdentifier;
    }

    /**
     * <p>
     * A unique EvaluationContextIdentifier ID for an EvaluationContext.
     * </p>
     * 
     * @return A unique EvaluationContextIdentifier ID for an EvaluationContext.
     */
    public final String evaluationContextIdentifier() {
        return evaluationContextIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationContextIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationContext)) {
            return false;
        }
        EvaluationContext other = (EvaluationContext) obj;
        return Objects.equals(evaluationContextIdentifier(), other.evaluationContextIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationContext").add("EvaluationContextIdentifier", evaluationContextIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationContextIdentifier":
            return Optional.ofNullable(clazz.cast(evaluationContextIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationContextIdentifier", EVALUATION_CONTEXT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationContext, T> g) {
        return obj -> g.apply((EvaluationContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationContext> {
        /**
         * <p>
         * A unique EvaluationContextIdentifier ID for an EvaluationContext.
         * </p>
         * 
         * @param evaluationContextIdentifier
         *        A unique EvaluationContextIdentifier ID for an EvaluationContext.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationContextIdentifier(String evaluationContextIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationContextIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationContext model) {
            evaluationContextIdentifier(model.evaluationContextIdentifier);
        }

        public final String getEvaluationContextIdentifier() {
            return evaluationContextIdentifier;
        }

        public final void setEvaluationContextIdentifier(String evaluationContextIdentifier) {
            this.evaluationContextIdentifier = evaluationContextIdentifier;
        }

        @Override
        public final Builder evaluationContextIdentifier(String evaluationContextIdentifier) {
            this.evaluationContextIdentifier = evaluationContextIdentifier;
            return this;
        }

        @Override
        public EvaluationContext build() {
            return new EvaluationContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
