/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigException;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.InsufficientDeliveryPolicyException;
import software.amazon.awssdk.services.config.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.config.model.InvalidConfigurationRecorderNameException;
import software.amazon.awssdk.services.config.model.InvalidDeliveryChannelNameException;
import software.amazon.awssdk.services.config.model.InvalidLimitException;
import software.amazon.awssdk.services.config.model.InvalidNextTokenException;
import software.amazon.awssdk.services.config.model.InvalidParameterValueException;
import software.amazon.awssdk.services.config.model.InvalidRecordingGroupException;
import software.amazon.awssdk.services.config.model.InvalidResultTokenException;
import software.amazon.awssdk.services.config.model.InvalidRoleException;
import software.amazon.awssdk.services.config.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.config.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.config.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.config.model.LastDeliveryChannelDeleteFailedException;
import software.amazon.awssdk.services.config.model.LimitExceededException;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfRetentionConfigurationsExceededException;
import software.amazon.awssdk.services.config.model.NoAvailableConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoAvailableDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.config.model.NoRunningConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchBucketException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationAggregatorException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoSuchRetentionConfigurationException;
import software.amazon.awssdk.services.config.model.OrganizationAccessDeniedException;
import software.amazon.awssdk.services.config.model.OrganizationAllFeaturesNotEnabledException;
import software.amazon.awssdk.services.config.model.OversizedConfigurationItemException;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.ResourceInUseException;
import software.amazon.awssdk.services.config.model.ResourceNotDiscoveredException;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.ValidationException;
import software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher;
import software.amazon.awssdk.services.config.transform.BatchGetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeletePendingAggregationRequestRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorSourcesStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribePendingAggregationRequestsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRetentionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConfigRuleComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListAggregateDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultConfigAsyncClient
implements ConfigAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConfigAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "config";
    }

    @Override
    public CompletableFuture<BatchGetAggregateResourceConfigResponse> batchGetAggregateResourceConfig(BatchGetAggregateResourceConfigRequest batchGetAggregateResourceConfigRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetAggregateResourceConfigResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetAggregateResourceConfig").withMarshaller((Marshaller)new BatchGetAggregateResourceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetAggregateResourceConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetResourceConfigResponse> batchGetResourceConfig(BatchGetResourceConfigRequest batchGetResourceConfigRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetResourceConfigResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetResourceConfig").withMarshaller((Marshaller)new BatchGetResourceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetResourceConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAggregationAuthorizationResponse> deleteAggregationAuthorization(DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAggregationAuthorizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAggregationAuthorization").withMarshaller((Marshaller)new DeleteAggregationAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAggregationAuthorizationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConfigRuleResponse> deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigRule").withMarshaller((Marshaller)new DeleteConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConfigurationAggregatorResponse> deleteConfigurationAggregator(DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationAggregatorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationAggregator").withMarshaller((Marshaller)new DeleteConfigurationAggregatorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationAggregatorRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConfigurationRecorderResponse> deleteConfigurationRecorder(DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationRecorderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationRecorder").withMarshaller((Marshaller)new DeleteConfigurationRecorderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationRecorderRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDeliveryChannelResponse> deleteDeliveryChannel(DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeliveryChannelResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDeliveryChannel").withMarshaller((Marshaller)new DeleteDeliveryChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDeliveryChannelRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEvaluationResultsResponse> deleteEvaluationResults(DeleteEvaluationResultsRequest deleteEvaluationResultsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEvaluationResultsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEvaluationResults").withMarshaller((Marshaller)new DeleteEvaluationResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEvaluationResultsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePendingAggregationRequestResponse> deletePendingAggregationRequest(DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePendingAggregationRequestResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePendingAggregationRequest").withMarshaller((Marshaller)new DeletePendingAggregationRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePendingAggregationRequestRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRetentionConfigurationResponse> deleteRetentionConfiguration(DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRetentionConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRetentionConfiguration").withMarshaller((Marshaller)new DeleteRetentionConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRetentionConfigurationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeliverConfigSnapshotResponse> deliverConfigSnapshot(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeliverConfigSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeliverConfigSnapshot").withMarshaller((Marshaller)new DeliverConfigSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deliverConfigSnapshotRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> describeAggregateComplianceByConfigRules(DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAggregateComplianceByConfigRulesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAggregateComplianceByConfigRules").withMarshaller((Marshaller)new DescribeAggregateComplianceByConfigRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAggregateComplianceByConfigRulesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAggregationAuthorizationsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAggregationAuthorizations").withMarshaller((Marshaller)new DescribeAggregationAuthorizationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAggregationAuthorizationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeComplianceByConfigRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeComplianceByConfigRule").withMarshaller((Marshaller)new DescribeComplianceByConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeComplianceByConfigRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource(DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeComplianceByResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeComplianceByResource").withMarshaller((Marshaller)new DescribeComplianceByResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeComplianceByResourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigRuleEvaluationStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigRuleEvaluationStatus").withMarshaller((Marshaller)new DescribeConfigRuleEvaluationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigRuleEvaluationStatusRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigRulesResponse> describeConfigRules(DescribeConfigRulesRequest describeConfigRulesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigRulesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigRules").withMarshaller((Marshaller)new DescribeConfigRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigRulesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> describeConfigurationAggregatorSourcesStatus(DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationAggregatorSourcesStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationAggregatorSourcesStatus").withMarshaller((Marshaller)new DescribeConfigurationAggregatorSourcesStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationAggregatorSourcesStatusRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationAggregatorsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationAggregators").withMarshaller((Marshaller)new DescribeConfigurationAggregatorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationAggregatorsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationRecorderStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationRecorderStatus").withMarshaller((Marshaller)new DescribeConfigurationRecorderStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationRecorderStatusRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders(DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationRecordersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationRecorders").withMarshaller((Marshaller)new DescribeConfigurationRecordersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationRecordersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeliveryChannelStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeliveryChannelStatus").withMarshaller((Marshaller)new DescribeDeliveryChannelStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeliveryChannelStatusRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels(DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeliveryChannelsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeliveryChannels").withMarshaller((Marshaller)new DescribeDeliveryChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeliveryChannelsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribePendingAggregationRequestsResponse> describePendingAggregationRequests(DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePendingAggregationRequestsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingAggregationRequests").withMarshaller((Marshaller)new DescribePendingAggregationRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePendingAggregationRequestsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRetentionConfigurationsResponse> describeRetentionConfigurations(DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRetentionConfigurationsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRetentionConfigurations").withMarshaller((Marshaller)new DescribeRetentionConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRetentionConfigurationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAggregateComplianceDetailsByConfigRuleResponse> getAggregateComplianceDetailsByConfigRule(GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAggregateComplianceDetailsByConfigRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAggregateComplianceDetailsByConfigRule").withMarshaller((Marshaller)new GetAggregateComplianceDetailsByConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAggregateComplianceDetailsByConfigRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAggregateConfigRuleComplianceSummaryResponse> getAggregateConfigRuleComplianceSummary(GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAggregateConfigRuleComplianceSummaryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAggregateConfigRuleComplianceSummary").withMarshaller((Marshaller)new GetAggregateConfigRuleComplianceSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAggregateConfigRuleComplianceSummaryRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAggregateDiscoveredResourceCountsResponse> getAggregateDiscoveredResourceCounts(GetAggregateDiscoveredResourceCountsRequest getAggregateDiscoveredResourceCountsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAggregateDiscoveredResourceCountsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAggregateDiscoveredResourceCounts").withMarshaller((Marshaller)new GetAggregateDiscoveredResourceCountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAggregateDiscoveredResourceCountsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAggregateResourceConfigResponse> getAggregateResourceConfig(GetAggregateResourceConfigRequest getAggregateResourceConfigRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAggregateResourceConfigResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAggregateResourceConfig").withMarshaller((Marshaller)new GetAggregateResourceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAggregateResourceConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetComplianceDetailsByConfigRuleResponse> getComplianceDetailsByConfigRule(GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetComplianceDetailsByConfigRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetComplianceDetailsByConfigRule").withMarshaller((Marshaller)new GetComplianceDetailsByConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComplianceDetailsByConfigRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetComplianceDetailsByResourceResponse> getComplianceDetailsByResource(GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetComplianceDetailsByResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetComplianceDetailsByResource").withMarshaller((Marshaller)new GetComplianceDetailsByResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComplianceDetailsByResourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetComplianceSummaryByConfigRuleResponse> getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetComplianceSummaryByConfigRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetComplianceSummaryByConfigRule").withMarshaller((Marshaller)new GetComplianceSummaryByConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComplianceSummaryByConfigRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetComplianceSummaryByResourceTypeResponse> getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetComplianceSummaryByResourceTypeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetComplianceSummaryByResourceType").withMarshaller((Marshaller)new GetComplianceSummaryByResourceTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComplianceSummaryByResourceTypeRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDiscoveredResourceCountsResponse> getDiscoveredResourceCounts(GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiscoveredResourceCountsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDiscoveredResourceCounts").withMarshaller((Marshaller)new GetDiscoveredResourceCountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDiscoveredResourceCountsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourceConfigHistoryResponse> getResourceConfigHistory(GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceConfigHistoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceConfigHistory").withMarshaller((Marshaller)new GetResourceConfigHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceConfigHistoryRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetResourceConfigHistoryPublisher getResourceConfigHistoryPaginator(GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) {
        return new GetResourceConfigHistoryPublisher(this, this.applyPaginatorUserAgent(getResourceConfigHistoryRequest));
    }

    @Override
    public CompletableFuture<ListAggregateDiscoveredResourcesResponse> listAggregateDiscoveredResources(ListAggregateDiscoveredResourcesRequest listAggregateDiscoveredResourcesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAggregateDiscoveredResourcesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAggregateDiscoveredResources").withMarshaller((Marshaller)new ListAggregateDiscoveredResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAggregateDiscoveredResourcesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDiscoveredResourcesResponse> listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDiscoveredResourcesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDiscoveredResources").withMarshaller((Marshaller)new ListDiscoveredResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDiscoveredResourcesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAggregationAuthorizationResponse> putAggregationAuthorization(PutAggregationAuthorizationRequest putAggregationAuthorizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAggregationAuthorizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAggregationAuthorization").withMarshaller((Marshaller)new PutAggregationAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAggregationAuthorizationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutConfigRuleResponse> putConfigRule(PutConfigRuleRequest putConfigRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigRule").withMarshaller((Marshaller)new PutConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutConfigurationAggregatorResponse> putConfigurationAggregator(PutConfigurationAggregatorRequest putConfigurationAggregatorRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationAggregatorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationAggregator").withMarshaller((Marshaller)new PutConfigurationAggregatorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationAggregatorRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutConfigurationRecorderResponse> putConfigurationRecorder(PutConfigurationRecorderRequest putConfigurationRecorderRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationRecorderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationRecorder").withMarshaller((Marshaller)new PutConfigurationRecorderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationRecorderRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDeliveryChannelResponse> putDeliveryChannel(PutDeliveryChannelRequest putDeliveryChannelRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDeliveryChannelResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDeliveryChannel").withMarshaller((Marshaller)new PutDeliveryChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDeliveryChannelRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutEvaluationsResponse> putEvaluations(PutEvaluationsRequest putEvaluationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEvaluationsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEvaluations").withMarshaller((Marshaller)new PutEvaluationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEvaluationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutRetentionConfigurationResponse> putRetentionConfiguration(PutRetentionConfigurationRequest putRetentionConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRetentionConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRetentionConfiguration").withMarshaller((Marshaller)new PutRetentionConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRetentionConfigurationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartConfigRulesEvaluationResponse> startConfigRulesEvaluation(StartConfigRulesEvaluationRequest startConfigRulesEvaluationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartConfigRulesEvaluationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartConfigRulesEvaluation").withMarshaller((Marshaller)new StartConfigRulesEvaluationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startConfigRulesEvaluationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartConfigurationRecorderResponse> startConfigurationRecorder(StartConfigurationRecorderRequest startConfigurationRecorderRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartConfigurationRecorderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartConfigurationRecorder").withMarshaller((Marshaller)new StartConfigurationRecorderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startConfigurationRecorderRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopConfigurationRecorderResponse> stopConfigurationRecorder(StopConfigurationRecorderRequest stopConfigurationRecorderRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopConfigurationRecorderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopConfigurationRecorder").withMarshaller((Marshaller)new StopConfigurationRecorderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopConfigurationRecorderRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ConfigException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").exceptionBuilderSupplier(InvalidParameterValueException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").exceptionBuilderSupplier(InvalidResultTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchBucketException").exceptionBuilderSupplier(NoSuchBucketException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").exceptionBuilderSupplier(InvalidTimeRangeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLimitException").exceptionBuilderSupplier(InvalidLimitException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRoleException").exceptionBuilderSupplier(InvalidRoleException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").exceptionBuilderSupplier(InsufficientPermissionsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
    }

    private <T extends ConfigRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.4.5").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ConfigRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

