/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.Compliance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateComplianceByConfigRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateComplianceByConfigRule> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(AggregateComplianceByConfigRule.getter(AggregateComplianceByConfigRule::configRuleName)).setter(AggregateComplianceByConfigRule.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<Compliance> COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Compliance").getter(AggregateComplianceByConfigRule.getter(AggregateComplianceByConfigRule::compliance)).setter(AggregateComplianceByConfigRule.setter(Builder::compliance)).constructor(Compliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compliance").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AggregateComplianceByConfigRule.getter(AggregateComplianceByConfigRule::accountId)).setter(AggregateComplianceByConfigRule.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(AggregateComplianceByConfigRule.getter(AggregateComplianceByConfigRule::awsRegion)).setter(AggregateComplianceByConfigRule.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, COMPLIANCE_FIELD, ACCOUNT_ID_FIELD, AWS_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregateComplianceByConfigRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configRuleName;
    private final Compliance compliance;
    private final String accountId;
    private final String awsRegion;

    private AggregateComplianceByConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.compliance = builder.compliance;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final Compliance compliance() {
        return this.compliance;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliance());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateComplianceByConfigRule)) {
            return false;
        }
        AggregateComplianceByConfigRule other = (AggregateComplianceByConfigRule)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.compliance(), other.compliance()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.awsRegion(), other.awsRegion());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateComplianceByConfigRule").add("ConfigRuleName", (Object)this.configRuleName()).add("Compliance", (Object)this.compliance()).add("AccountId", (Object)this.accountId()).add("AwsRegion", (Object)this.awsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "Compliance": {
                return Optional.ofNullable(clazz.cast(this.compliance()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigRuleName", CONFIG_RULE_NAME_FIELD);
        map.put("Compliance", COMPLIANCE_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AwsRegion", AWS_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateComplianceByConfigRule, T> g) {
        return obj -> g.apply((AggregateComplianceByConfigRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private Compliance compliance;
        private String accountId;
        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateComplianceByConfigRule model) {
            this.configRuleName(model.configRuleName);
            this.compliance(model.compliance);
            this.accountId(model.accountId);
            this.awsRegion(model.awsRegion);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final Compliance.Builder getCompliance() {
            return this.compliance != null ? this.compliance.toBuilder() : null;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public AggregateComplianceByConfigRule build() {
            return new AggregateComplianceByConfigRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateComplianceByConfigRule> {
        public Builder configRuleName(String var1);

        public Builder compliance(Compliance var1);

        default public Builder compliance(Consumer<Compliance.Builder> compliance) {
            return this.compliance((Compliance)((Compliance.Builder)Compliance.builder().applyMutation(compliance)).build());
        }

        public Builder accountId(String var1);

        public Builder awsRegion(String var1);
    }
}

