/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.OrganizationResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationConformancePackStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationConformancePackStatus> {
    private static final SdkField<String> ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationConformancePackName").getter(OrganizationConformancePackStatus.getter(OrganizationConformancePackStatus::organizationConformancePackName)).setter(OrganizationConformancePackStatus.setter(Builder::organizationConformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OrganizationConformancePackStatus.getter(OrganizationConformancePackStatus::statusAsString)).setter(OrganizationConformancePackStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(OrganizationConformancePackStatus.getter(OrganizationConformancePackStatus::errorCode)).setter(OrganizationConformancePackStatus.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(OrganizationConformancePackStatus.getter(OrganizationConformancePackStatus::errorMessage)).setter(OrganizationConformancePackStatus.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(OrganizationConformancePackStatus.getter(OrganizationConformancePackStatus::lastUpdateTime)).setter(OrganizationConformancePackStatus.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD, STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrganizationConformancePackStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String organizationConformancePackName;
    private final String status;
    private final String errorCode;
    private final String errorMessage;
    private final Instant lastUpdateTime;

    private OrganizationConformancePackStatus(BuilderImpl builder) {
        this.organizationConformancePackName = builder.organizationConformancePackName;
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String organizationConformancePackName() {
        return this.organizationConformancePackName;
    }

    public final OrganizationResourceStatus status() {
        return OrganizationResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConformancePackStatus)) {
            return false;
        }
        OrganizationConformancePackStatus other = (OrganizationConformancePackStatus)obj;
        return Objects.equals(this.organizationConformancePackName(), other.organizationConformancePackName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationConformancePackStatus").add("OrganizationConformancePackName", (Object)this.organizationConformancePackName()).add("Status", (Object)this.statusAsString()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.organizationConformancePackName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationConformancePackName", ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConformancePackStatus, T> g) {
        return obj -> g.apply((OrganizationConformancePackStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationConformancePackName;
        private String status;
        private String errorCode;
        private String errorMessage;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConformancePackStatus model) {
            this.organizationConformancePackName(model.organizationConformancePackName);
            this.status(model.status);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getOrganizationConformancePackName() {
            return this.organizationConformancePackName;
        }

        public final void setOrganizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
        }

        @Override
        public final Builder organizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public OrganizationConformancePackStatus build() {
            return new OrganizationConformancePackStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationConformancePackStatus> {
        public Builder organizationConformancePackName(String var1);

        public Builder status(String var1);

        public Builder status(OrganizationResourceStatus var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

