/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ComplianceByConfigRule;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;

public class DescribeComplianceByConfigRuleIterable
implements SdkIterable<DescribeComplianceByConfigRuleResponse> {
    private final ConfigClient client;
    private final DescribeComplianceByConfigRuleRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeComplianceByConfigRuleIterable(ConfigClient client, DescribeComplianceByConfigRuleRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeComplianceByConfigRuleResponseFetcher();
    }

    public Iterator<DescribeComplianceByConfigRuleResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComplianceByConfigRule> complianceByConfigRules() {
        Function<DescribeComplianceByConfigRuleResponse, Iterator> getIterator = response -> {
            if (response != null && response.complianceByConfigRules() != null) {
                return response.complianceByConfigRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeComplianceByConfigRuleResponseFetcher
    implements SyncPageFetcher<DescribeComplianceByConfigRuleResponse> {
        private DescribeComplianceByConfigRuleResponseFetcher() {
        }

        public boolean hasNextPage(DescribeComplianceByConfigRuleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeComplianceByConfigRuleResponse nextPage(DescribeComplianceByConfigRuleResponse previousPage) {
            if (previousPage == null) {
                return DescribeComplianceByConfigRuleIterable.this.client.describeComplianceByConfigRule(DescribeComplianceByConfigRuleIterable.this.firstRequest);
            }
            return DescribeComplianceByConfigRuleIterable.this.client.describeComplianceByConfigRule((DescribeComplianceByConfigRuleRequest)((Object)DescribeComplianceByConfigRuleIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

