/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse;
import software.amazon.awssdk.services.config.model.ResourceEvaluation;

public class ListResourceEvaluationsPublisher
implements SdkPublisher<ListResourceEvaluationsResponse> {
    private final ConfigAsyncClient client;
    private final ListResourceEvaluationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceEvaluationsPublisher(ConfigAsyncClient client, ListResourceEvaluationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceEvaluationsPublisher(ConfigAsyncClient client, ListResourceEvaluationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceEvaluationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceEvaluationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceEvaluation> resourceEvaluations() {
        Function<ListResourceEvaluationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceEvaluations() != null) {
                return response.resourceEvaluations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceEvaluationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceEvaluationsResponseFetcher
    implements AsyncPageFetcher<ListResourceEvaluationsResponse> {
        private ListResourceEvaluationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceEvaluationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceEvaluationsResponse> nextPage(ListResourceEvaluationsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceEvaluationsPublisher.this.client.listResourceEvaluations(ListResourceEvaluationsPublisher.this.firstRequest);
            }
            return ListResourceEvaluationsPublisher.this.client.listResourceEvaluations((ListResourceEvaluationsRequest)((Object)ListResourceEvaluationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

