/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.AggregatorFilterResourceType;
import software.amazon.awssdk.services.config.model.AggregatorFilterServicePrincipal;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregatorFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregatorFilters> {
    private static final SdkField<AggregatorFilterResourceType> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceType").getter(AggregatorFilters.getter(AggregatorFilters::resourceType)).setter(AggregatorFilters.setter(Builder::resourceType)).constructor(AggregatorFilterResourceType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<AggregatorFilterServicePrincipal> SERVICE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServicePrincipal").getter(AggregatorFilters.getter(AggregatorFilters::servicePrincipal)).setter(AggregatorFilters.setter(Builder::servicePrincipal)).constructor(AggregatorFilterServicePrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, SERVICE_PRINCIPAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregatorFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AggregatorFilterResourceType resourceType;
    private final AggregatorFilterServicePrincipal servicePrincipal;

    private AggregatorFilters(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.servicePrincipal = builder.servicePrincipal;
    }

    public final AggregatorFilterResourceType resourceType() {
        return this.resourceType;
    }

    public final AggregatorFilterServicePrincipal servicePrincipal() {
        return this.servicePrincipal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePrincipal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatorFilters)) {
            return false;
        }
        AggregatorFilters other = (AggregatorFilters)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.servicePrincipal(), other.servicePrincipal());
    }

    public final String toString() {
        return ToString.builder((String)"AggregatorFilters").add("ResourceType", (Object)this.resourceType()).add("ServicePrincipal", (Object)this.servicePrincipal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ServicePrincipal": {
                return Optional.ofNullable(clazz.cast(this.servicePrincipal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ServicePrincipal", SERVICE_PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregatorFilters, T> g) {
        return obj -> g.apply((AggregatorFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AggregatorFilterResourceType resourceType;
        private AggregatorFilterServicePrincipal servicePrincipal;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatorFilters model) {
            this.resourceType(model.resourceType);
            this.servicePrincipal(model.servicePrincipal);
        }

        public final AggregatorFilterResourceType.Builder getResourceType() {
            return this.resourceType != null ? this.resourceType.toBuilder() : null;
        }

        public final void setResourceType(AggregatorFilterResourceType.BuilderImpl resourceType) {
            this.resourceType = resourceType != null ? resourceType.build() : null;
        }

        @Override
        public final Builder resourceType(AggregatorFilterResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final AggregatorFilterServicePrincipal.Builder getServicePrincipal() {
            return this.servicePrincipal != null ? this.servicePrincipal.toBuilder() : null;
        }

        public final void setServicePrincipal(AggregatorFilterServicePrincipal.BuilderImpl servicePrincipal) {
            this.servicePrincipal = servicePrincipal != null ? servicePrincipal.build() : null;
        }

        @Override
        public final Builder servicePrincipal(AggregatorFilterServicePrincipal servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public AggregatorFilters build() {
            return new AggregatorFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregatorFilters> {
        public Builder resourceType(AggregatorFilterResourceType var1);

        default public Builder resourceType(Consumer<AggregatorFilterResourceType.Builder> resourceType) {
            return this.resourceType((AggregatorFilterResourceType)((AggregatorFilterResourceType.Builder)AggregatorFilterResourceType.builder().applyMutation(resourceType)).build());
        }

        public Builder servicePrincipal(AggregatorFilterServicePrincipal var1);

        default public Builder servicePrincipal(Consumer<AggregatorFilterServicePrincipal.Builder> servicePrincipal) {
            return this.servicePrincipal((AggregatorFilterServicePrincipal)((AggregatorFilterServicePrincipal.Builder)AggregatorFilterServicePrincipal.builder().applyMutation(servicePrincipal)).build());
        }
    }
}

