/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AccountAggregationSourceAccountListCopier;
import software.amazon.awssdk.services.config.model.AggregatorRegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountAggregationSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountAggregationSource> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(AccountAggregationSource.getter(AccountAggregationSource::accountIds)).setter(AccountAggregationSource.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllAwsRegions").getter(AccountAggregationSource.getter(AccountAggregationSource::allAwsRegions)).setter(AccountAggregationSource.setter(Builder::allAwsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllAwsRegions").build()}).build();
    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsRegions").getter(AccountAggregationSource.getter(AccountAggregationSource::awsRegions)).setter(AccountAggregationSource.setter(Builder::awsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, ALL_AWS_REGIONS_FIELD, AWS_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountAggregationSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> accountIds;
    private final Boolean allAwsRegions;
    private final List<String> awsRegions;

    private AccountAggregationSource(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.allAwsRegions = builder.allAwsRegions;
        this.awsRegions = builder.awsRegions;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final Boolean allAwsRegions() {
        return this.allAwsRegions;
    }

    public final boolean hasAwsRegions() {
        return this.awsRegions != null && !(this.awsRegions instanceof SdkAutoConstructList);
    }

    public final List<String> awsRegions() {
        return this.awsRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allAwsRegions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsRegions() ? this.awsRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAggregationSource)) {
            return false;
        }
        AccountAggregationSource other = (AccountAggregationSource)obj;
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.allAwsRegions(), other.allAwsRegions()) && this.hasAwsRegions() == other.hasAwsRegions() && Objects.equals(this.awsRegions(), other.awsRegions());
    }

    public final String toString() {
        return ToString.builder((String)"AccountAggregationSource").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("AllAwsRegions", (Object)this.allAwsRegions()).add("AwsRegions", this.hasAwsRegions() ? this.awsRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "AllAwsRegions": {
                return Optional.ofNullable(clazz.cast(this.allAwsRegions()));
            }
            case "AwsRegions": {
                return Optional.ofNullable(clazz.cast(this.awsRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountIds", ACCOUNT_IDS_FIELD);
        map.put("AllAwsRegions", ALL_AWS_REGIONS_FIELD);
        map.put("AwsRegions", AWS_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountAggregationSource, T> g) {
        return obj -> g.apply((AccountAggregationSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean allAwsRegions;
        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAggregationSource model) {
            this.accountIds(model.accountIds);
            this.allAwsRegions(model.allAwsRegions);
            this.awsRegions(model.awsRegions);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountAggregationSourceAccountListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountAggregationSourceAccountListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Boolean getAllAwsRegions() {
            return this.allAwsRegions;
        }

        public final void setAllAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
        }

        @Override
        public final Builder allAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
            return this;
        }

        public final Collection<String> getAwsRegions() {
            if (this.awsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsRegions;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
        }

        @Override
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsRegions(String ... awsRegions) {
            this.awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public AccountAggregationSource build() {
            return new AccountAggregationSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountAggregationSource> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder allAwsRegions(Boolean var1);

        public Builder awsRegions(Collection<String> var1);

        public Builder awsRegions(String ... var1);
    }
}

