/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConformancePackDetail;
import software.amazon.awssdk.services.config.model.ConformancePackDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConformancePacksResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConformancePacksResponse> {
    private static final SdkField<List<ConformancePackDetail>> CONFORMANCE_PACK_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConformancePackDetails").getter(DescribeConformancePacksResponse.getter(DescribeConformancePacksResponse::conformancePackDetails)).setter(DescribeConformancePacksResponse.setter(Builder::conformancePackDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConformancePackDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConformancePacksResponse.getter(DescribeConformancePacksResponse::nextToken)).setter(DescribeConformancePacksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConformancePacksResponse.memberNameToFieldInitializer();
    private final List<ConformancePackDetail> conformancePackDetails;
    private final String nextToken;

    private DescribeConformancePacksResponse(BuilderImpl builder) {
        super(builder);
        this.conformancePackDetails = builder.conformancePackDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConformancePackDetails() {
        return this.conformancePackDetails != null && !(this.conformancePackDetails instanceof SdkAutoConstructList);
    }

    public final List<ConformancePackDetail> conformancePackDetails() {
        return this.conformancePackDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConformancePackDetails() ? this.conformancePackDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConformancePacksResponse)) {
            return false;
        }
        DescribeConformancePacksResponse other = (DescribeConformancePacksResponse)((Object)obj);
        return this.hasConformancePackDetails() == other.hasConformancePackDetails() && Objects.equals(this.conformancePackDetails(), other.conformancePackDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConformancePacksResponse").add("ConformancePackDetails", this.hasConformancePackDetails() ? this.conformancePackDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConformancePackDetails": {
                return Optional.ofNullable(clazz.cast(this.conformancePackDetails()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConformancePackDetails", CONFORMANCE_PACK_DETAILS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConformancePacksResponse, T> g) {
        return obj -> g.apply((DescribeConformancePacksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConformancePackDetail> conformancePackDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConformancePacksResponse model) {
            super(model);
            this.conformancePackDetails(model.conformancePackDetails);
            this.nextToken(model.nextToken);
        }

        public final List<ConformancePackDetail.Builder> getConformancePackDetails() {
            List<ConformancePackDetail.Builder> result = ConformancePackDetailListCopier.copyToBuilder(this.conformancePackDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConformancePackDetails(Collection<ConformancePackDetail.BuilderImpl> conformancePackDetails) {
            this.conformancePackDetails = ConformancePackDetailListCopier.copyFromBuilder(conformancePackDetails);
        }

        @Override
        public final Builder conformancePackDetails(Collection<ConformancePackDetail> conformancePackDetails) {
            this.conformancePackDetails = ConformancePackDetailListCopier.copy(conformancePackDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackDetails(ConformancePackDetail ... conformancePackDetails) {
            this.conformancePackDetails(Arrays.asList(conformancePackDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackDetails(Consumer<ConformancePackDetail.Builder> ... conformancePackDetails) {
            this.conformancePackDetails(Stream.of(conformancePackDetails).map(c -> (ConformancePackDetail)((ConformancePackDetail.Builder)ConformancePackDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConformancePacksResponse build() {
            return new DescribeConformancePacksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConformancePacksResponse> {
        public Builder conformancePackDetails(Collection<ConformancePackDetail> var1);

        public Builder conformancePackDetails(ConformancePackDetail ... var1);

        public Builder conformancePackDetails(Consumer<ConformancePackDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

