/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregatorRegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationAggregationSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationAggregationSource> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(OrganizationAggregationSource.getter(OrganizationAggregationSource::roleArn)).setter(OrganizationAggregationSource.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsRegions").getter(OrganizationAggregationSource.getter(OrganizationAggregationSource::awsRegions)).setter(OrganizationAggregationSource.setter(Builder::awsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllAwsRegions").getter(OrganizationAggregationSource.getter(OrganizationAggregationSource::allAwsRegions)).setter(OrganizationAggregationSource.setter(Builder::allAwsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllAwsRegions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, AWS_REGIONS_FIELD, ALL_AWS_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrganizationAggregationSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final List<String> awsRegions;
    private final Boolean allAwsRegions;

    private OrganizationAggregationSource(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.awsRegions = builder.awsRegions;
        this.allAwsRegions = builder.allAwsRegions;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasAwsRegions() {
        return this.awsRegions != null && !(this.awsRegions instanceof SdkAutoConstructList);
    }

    public final List<String> awsRegions() {
        return this.awsRegions;
    }

    public final Boolean allAwsRegions() {
        return this.allAwsRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsRegions() ? this.awsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allAwsRegions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationAggregationSource)) {
            return false;
        }
        OrganizationAggregationSource other = (OrganizationAggregationSource)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && this.hasAwsRegions() == other.hasAwsRegions() && Objects.equals(this.awsRegions(), other.awsRegions()) && Objects.equals(this.allAwsRegions(), other.allAwsRegions());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationAggregationSource").add("RoleArn", (Object)this.roleArn()).add("AwsRegions", this.hasAwsRegions() ? this.awsRegions() : null).add("AllAwsRegions", (Object)this.allAwsRegions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "AwsRegions": {
                return Optional.ofNullable(clazz.cast(this.awsRegions()));
            }
            case "AllAwsRegions": {
                return Optional.ofNullable(clazz.cast(this.allAwsRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("AwsRegions", AWS_REGIONS_FIELD);
        map.put("AllAwsRegions", ALL_AWS_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationAggregationSource, T> g) {
        return obj -> g.apply((OrganizationAggregationSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();
        private Boolean allAwsRegions;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationAggregationSource model) {
            this.roleArn(model.roleArn);
            this.awsRegions(model.awsRegions);
            this.allAwsRegions(model.allAwsRegions);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getAwsRegions() {
            if (this.awsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsRegions;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
        }

        @Override
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsRegions(String ... awsRegions) {
            this.awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final Boolean getAllAwsRegions() {
            return this.allAwsRegions;
        }

        public final void setAllAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
        }

        @Override
        public final Builder allAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
            return this;
        }

        public OrganizationAggregationSource build() {
            return new OrganizationAggregationSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationAggregationSource> {
        public Builder roleArn(String var1);

        public Builder awsRegions(Collection<String> var1);

        public Builder awsRegions(String ... var1);

        public Builder allAwsRegions(Boolean var1);
    }
}

