/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.RecordingScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationRecorderSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationRecorderSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ConfigurationRecorderSummary.getter(ConfigurationRecorderSummary::arn)).setter(ConfigurationRecorderSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ConfigurationRecorderSummary.getter(ConfigurationRecorderSummary::name)).setter(ConfigurationRecorderSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("servicePrincipal").getter(ConfigurationRecorderSummary.getter(ConfigurationRecorderSummary::servicePrincipal)).setter(ConfigurationRecorderSummary.setter(Builder::servicePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servicePrincipal").build()}).build();
    private static final SdkField<String> RECORDING_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingScope").getter(ConfigurationRecorderSummary.getter(ConfigurationRecorderSummary::recordingScopeAsString)).setter(ConfigurationRecorderSummary.setter(Builder::recordingScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, SERVICE_PRINCIPAL_FIELD, RECORDING_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationRecorderSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String servicePrincipal;
    private final String recordingScope;

    private ConfigurationRecorderSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.servicePrincipal = builder.servicePrincipal;
        this.recordingScope = builder.recordingScope;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String servicePrincipal() {
        return this.servicePrincipal;
    }

    public final RecordingScope recordingScope() {
        return RecordingScope.fromValue(this.recordingScope);
    }

    public final String recordingScopeAsString() {
        return this.recordingScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderSummary)) {
            return false;
        }
        ConfigurationRecorderSummary other = (ConfigurationRecorderSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.servicePrincipal(), other.servicePrincipal()) && Objects.equals(this.recordingScopeAsString(), other.recordingScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationRecorderSummary").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("ServicePrincipal", (Object)this.servicePrincipal()).add("RecordingScope", (Object)this.recordingScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "servicePrincipal": {
                return Optional.ofNullable(clazz.cast(this.servicePrincipal()));
            }
            case "recordingScope": {
                return Optional.ofNullable(clazz.cast(this.recordingScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("servicePrincipal", SERVICE_PRINCIPAL_FIELD);
        map.put("recordingScope", RECORDING_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorderSummary, T> g) {
        return obj -> g.apply((ConfigurationRecorderSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String servicePrincipal;
        private String recordingScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderSummary model) {
            this.arn(model.arn);
            this.name(model.name);
            this.servicePrincipal(model.servicePrincipal);
            this.recordingScope(model.recordingScope);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServicePrincipal() {
            return this.servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final String getRecordingScope() {
            return this.recordingScope;
        }

        public final void setRecordingScope(String recordingScope) {
            this.recordingScope = recordingScope;
        }

        @Override
        public final Builder recordingScope(String recordingScope) {
            this.recordingScope = recordingScope;
            return this;
        }

        @Override
        public final Builder recordingScope(RecordingScope recordingScope) {
            this.recordingScope(recordingScope == null ? null : recordingScope.toString());
            return this;
        }

        public ConfigurationRecorderSummary build() {
            return new ConfigurationRecorderSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationRecorderSummary> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder servicePrincipal(String var1);

        public Builder recordingScope(String var1);

        public Builder recordingScope(RecordingScope var1);
    }
}

