/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregateResourceIdentifier;
import software.amazon.awssdk.services.config.model.BaseConfigurationItem;
import software.amazon.awssdk.services.config.model.BaseConfigurationItemsCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.UnprocessedResourceIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAggregateResourceConfigResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, BatchGetAggregateResourceConfigResponse> {
    private static final SdkField<List<BaseConfigurationItem>> BASE_CONFIGURATION_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BaseConfigurationItems").getter(BatchGetAggregateResourceConfigResponse.getter(BatchGetAggregateResourceConfigResponse::baseConfigurationItems)).setter(BatchGetAggregateResourceConfigResponse.setter(Builder::baseConfigurationItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseConfigurationItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BaseConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AggregateResourceIdentifier>> UNPROCESSED_RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedResourceIdentifiers").getter(BatchGetAggregateResourceConfigResponse.getter(BatchGetAggregateResourceConfigResponse::unprocessedResourceIdentifiers)).setter(BatchGetAggregateResourceConfigResponse.setter(Builder::unprocessedResourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedResourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregateResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_CONFIGURATION_ITEMS_FIELD, UNPROCESSED_RESOURCE_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetAggregateResourceConfigResponse.memberNameToFieldInitializer();
    private final List<BaseConfigurationItem> baseConfigurationItems;
    private final List<AggregateResourceIdentifier> unprocessedResourceIdentifiers;

    private BatchGetAggregateResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.baseConfigurationItems = builder.baseConfigurationItems;
        this.unprocessedResourceIdentifiers = builder.unprocessedResourceIdentifiers;
    }

    public final boolean hasBaseConfigurationItems() {
        return this.baseConfigurationItems != null && !(this.baseConfigurationItems instanceof SdkAutoConstructList);
    }

    public final List<BaseConfigurationItem> baseConfigurationItems() {
        return this.baseConfigurationItems;
    }

    public final boolean hasUnprocessedResourceIdentifiers() {
        return this.unprocessedResourceIdentifiers != null && !(this.unprocessedResourceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<AggregateResourceIdentifier> unprocessedResourceIdentifiers() {
        return this.unprocessedResourceIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaseConfigurationItems() ? this.baseConfigurationItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedResourceIdentifiers() ? this.unprocessedResourceIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAggregateResourceConfigResponse)) {
            return false;
        }
        BatchGetAggregateResourceConfigResponse other = (BatchGetAggregateResourceConfigResponse)((Object)obj);
        return this.hasBaseConfigurationItems() == other.hasBaseConfigurationItems() && Objects.equals(this.baseConfigurationItems(), other.baseConfigurationItems()) && this.hasUnprocessedResourceIdentifiers() == other.hasUnprocessedResourceIdentifiers() && Objects.equals(this.unprocessedResourceIdentifiers(), other.unprocessedResourceIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAggregateResourceConfigResponse").add("BaseConfigurationItems", this.hasBaseConfigurationItems() ? this.baseConfigurationItems() : null).add("UnprocessedResourceIdentifiers", this.hasUnprocessedResourceIdentifiers() ? this.unprocessedResourceIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseConfigurationItems": {
                return Optional.ofNullable(clazz.cast(this.baseConfigurationItems()));
            }
            case "UnprocessedResourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.unprocessedResourceIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BaseConfigurationItems", BASE_CONFIGURATION_ITEMS_FIELD);
        map.put("UnprocessedResourceIdentifiers", UNPROCESSED_RESOURCE_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAggregateResourceConfigResponse, T> g) {
        return obj -> g.apply((BatchGetAggregateResourceConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<BaseConfigurationItem> baseConfigurationItems = DefaultSdkAutoConstructList.getInstance();
        private List<AggregateResourceIdentifier> unprocessedResourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAggregateResourceConfigResponse model) {
            super(model);
            this.baseConfigurationItems(model.baseConfigurationItems);
            this.unprocessedResourceIdentifiers(model.unprocessedResourceIdentifiers);
        }

        public final List<BaseConfigurationItem.Builder> getBaseConfigurationItems() {
            List<BaseConfigurationItem.Builder> result = BaseConfigurationItemsCopier.copyToBuilder(this.baseConfigurationItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaseConfigurationItems(Collection<BaseConfigurationItem.BuilderImpl> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copyFromBuilder(baseConfigurationItems);
        }

        @Override
        public final Builder baseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copy(baseConfigurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(BaseConfigurationItem ... baseConfigurationItems) {
            this.baseConfigurationItems(Arrays.asList(baseConfigurationItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder> ... baseConfigurationItems) {
            this.baseConfigurationItems(Stream.of(baseConfigurationItems).map(c -> (BaseConfigurationItem)((BaseConfigurationItem.Builder)BaseConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AggregateResourceIdentifier.Builder> getUnprocessedResourceIdentifiers() {
            List<AggregateResourceIdentifier.Builder> result = UnprocessedResourceIdentifierListCopier.copyToBuilder(this.unprocessedResourceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedResourceIdentifiers(Collection<AggregateResourceIdentifier.BuilderImpl> unprocessedResourceIdentifiers) {
            this.unprocessedResourceIdentifiers = UnprocessedResourceIdentifierListCopier.copyFromBuilder(unprocessedResourceIdentifiers);
        }

        @Override
        public final Builder unprocessedResourceIdentifiers(Collection<AggregateResourceIdentifier> unprocessedResourceIdentifiers) {
            this.unprocessedResourceIdentifiers = UnprocessedResourceIdentifierListCopier.copy(unprocessedResourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceIdentifiers(AggregateResourceIdentifier ... unprocessedResourceIdentifiers) {
            this.unprocessedResourceIdentifiers(Arrays.asList(unprocessedResourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder> ... unprocessedResourceIdentifiers) {
            this.unprocessedResourceIdentifiers(Stream.of(unprocessedResourceIdentifiers).map(c -> (AggregateResourceIdentifier)((AggregateResourceIdentifier.Builder)AggregateResourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetAggregateResourceConfigResponse build() {
            return new BatchGetAggregateResourceConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAggregateResourceConfigResponse> {
        public Builder baseConfigurationItems(Collection<BaseConfigurationItem> var1);

        public Builder baseConfigurationItems(BaseConfigurationItem ... var1);

        public Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder> ... var1);

        public Builder unprocessedResourceIdentifiers(Collection<AggregateResourceIdentifier> var1);

        public Builder unprocessedResourceIdentifiers(AggregateResourceIdentifier ... var1);

        public Builder unprocessedResourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder> ... var1);
    }
}

