/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceScore;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceScoresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConformancePackComplianceScoresResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, ListConformancePackComplianceScoresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConformancePackComplianceScoresResponse.getter(ListConformancePackComplianceScoresResponse::nextToken)).setter(ListConformancePackComplianceScoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ConformancePackComplianceScore>> CONFORMANCE_PACK_COMPLIANCE_SCORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConformancePackComplianceScores").getter(ListConformancePackComplianceScoresResponse.getter(ListConformancePackComplianceScoresResponse::conformancePackComplianceScores)).setter(ListConformancePackComplianceScoresResponse.setter(Builder::conformancePackComplianceScores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackComplianceScores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConformancePackComplianceScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CONFORMANCE_PACK_COMPLIANCE_SCORES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ConformancePackComplianceScores", CONFORMANCE_PACK_COMPLIANCE_SCORES_FIELD);
        }
    });
    private final String nextToken;
    private final List<ConformancePackComplianceScore> conformancePackComplianceScores;

    private ListConformancePackComplianceScoresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.conformancePackComplianceScores = builder.conformancePackComplianceScores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasConformancePackComplianceScores() {
        return this.conformancePackComplianceScores != null && !(this.conformancePackComplianceScores instanceof SdkAutoConstructList);
    }

    public final List<ConformancePackComplianceScore> conformancePackComplianceScores() {
        return this.conformancePackComplianceScores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConformancePackComplianceScores() ? this.conformancePackComplianceScores() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConformancePackComplianceScoresResponse)) {
            return false;
        }
        ListConformancePackComplianceScoresResponse other = (ListConformancePackComplianceScoresResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasConformancePackComplianceScores() == other.hasConformancePackComplianceScores() && Objects.equals(this.conformancePackComplianceScores(), other.conformancePackComplianceScores());
    }

    public final String toString() {
        return ToString.builder((String)"ListConformancePackComplianceScoresResponse").add("NextToken", (Object)this.nextToken()).add("ConformancePackComplianceScores", this.hasConformancePackComplianceScores() ? this.conformancePackComplianceScores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ConformancePackComplianceScores": {
                return Optional.ofNullable(clazz.cast(this.conformancePackComplianceScores()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListConformancePackComplianceScoresResponse, T> g) {
        return obj -> g.apply((ListConformancePackComplianceScoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ConformancePackComplianceScore> conformancePackComplianceScores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConformancePackComplianceScoresResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.conformancePackComplianceScores(model.conformancePackComplianceScores);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ConformancePackComplianceScore.Builder> getConformancePackComplianceScores() {
            List<ConformancePackComplianceScore.Builder> result = ConformancePackComplianceScoresCopier.copyToBuilder(this.conformancePackComplianceScores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConformancePackComplianceScores(Collection<ConformancePackComplianceScore.BuilderImpl> conformancePackComplianceScores) {
            this.conformancePackComplianceScores = ConformancePackComplianceScoresCopier.copyFromBuilder(conformancePackComplianceScores);
        }

        @Override
        public final Builder conformancePackComplianceScores(Collection<ConformancePackComplianceScore> conformancePackComplianceScores) {
            this.conformancePackComplianceScores = ConformancePackComplianceScoresCopier.copy(conformancePackComplianceScores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackComplianceScores(ConformancePackComplianceScore ... conformancePackComplianceScores) {
            this.conformancePackComplianceScores(Arrays.asList(conformancePackComplianceScores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackComplianceScores(Consumer<ConformancePackComplianceScore.Builder> ... conformancePackComplianceScores) {
            this.conformancePackComplianceScores(Stream.of(conformancePackComplianceScores).map(c -> (ConformancePackComplianceScore)((ConformancePackComplianceScore.Builder)ConformancePackComplianceScore.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConformancePackComplianceScoresResponse build() {
            return new ListConformancePackComplianceScoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConformancePackComplianceScoresResponse> {
        public Builder nextToken(String var1);

        public Builder conformancePackComplianceScores(Collection<ConformancePackComplianceScore> var1);

        public Builder conformancePackComplianceScores(ConformancePackComplianceScore ... var1);

        public Builder conformancePackComplianceScores(Consumer<ConformancePackComplianceScore.Builder> ... var1);
    }
}

