/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConfigRuleStatusesRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeOrganizationConfigRuleStatusesRequest> {
    private static final SdkField<List<String>> ORGANIZATION_CONFIG_RULE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConfigRuleNames").getter(DescribeOrganizationConfigRuleStatusesRequest.getter(DescribeOrganizationConfigRuleStatusesRequest::organizationConfigRuleNames)).setter(DescribeOrganizationConfigRuleStatusesRequest.setter(Builder::organizationConfigRuleNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeOrganizationConfigRuleStatusesRequest.getter(DescribeOrganizationConfigRuleStatusesRequest::limit)).setter(DescribeOrganizationConfigRuleStatusesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationConfigRuleStatusesRequest.getter(DescribeOrganizationConfigRuleStatusesRequest::nextToken)).setter(DescribeOrganizationConfigRuleStatusesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFIG_RULE_NAMES_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrganizationConfigRuleNames", ORGANIZATION_CONFIG_RULE_NAMES_FIELD);
            this.put("Limit", LIMIT_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> organizationConfigRuleNames;
    private final Integer limit;
    private final String nextToken;

    private DescribeOrganizationConfigRuleStatusesRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleNames = builder.organizationConfigRuleNames;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOrganizationConfigRuleNames() {
        return this.organizationConfigRuleNames != null && !(this.organizationConfigRuleNames instanceof SdkAutoConstructList);
    }

    public final List<String> organizationConfigRuleNames() {
        return this.organizationConfigRuleNames;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationConfigRuleNames() ? this.organizationConfigRuleNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigRuleStatusesRequest)) {
            return false;
        }
        DescribeOrganizationConfigRuleStatusesRequest other = (DescribeOrganizationConfigRuleStatusesRequest)((Object)obj);
        return this.hasOrganizationConfigRuleNames() == other.hasOrganizationConfigRuleNames() && Objects.equals(this.organizationConfigRuleNames(), other.organizationConfigRuleNames()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationConfigRuleStatusesRequest").add("OrganizationConfigRuleNames", this.hasOrganizationConfigRuleNames() ? this.organizationConfigRuleNames() : null).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConfigRuleNames": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleNames()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigRuleStatusesRequest, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigRuleStatusesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<String> organizationConfigRuleNames = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigRuleStatusesRequest model) {
            super(model);
            this.organizationConfigRuleNames(model.organizationConfigRuleNames);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getOrganizationConfigRuleNames() {
            if (this.organizationConfigRuleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationConfigRuleNames;
        }

        public final void setOrganizationConfigRuleNames(Collection<String> organizationConfigRuleNames) {
            this.organizationConfigRuleNames = OrganizationConfigRuleNamesCopier.copy(organizationConfigRuleNames);
        }

        @Override
        public final Builder organizationConfigRuleNames(Collection<String> organizationConfigRuleNames) {
            this.organizationConfigRuleNames = OrganizationConfigRuleNamesCopier.copy(organizationConfigRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleNames(String ... organizationConfigRuleNames) {
            this.organizationConfigRuleNames(Arrays.asList(organizationConfigRuleNames));
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOrganizationConfigRuleStatusesRequest build() {
            return new DescribeOrganizationConfigRuleStatusesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConfigRuleStatusesRequest> {
        public Builder organizationConfigRuleNames(Collection<String> var1);

        public Builder organizationConfigRuleNames(String ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

