/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.RetentionConfiguration;

public class DescribeRetentionConfigurationsIterable
implements SdkIterable<DescribeRetentionConfigurationsResponse> {
    private final ConfigClient client;
    private final DescribeRetentionConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRetentionConfigurationsIterable(ConfigClient client, DescribeRetentionConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeRetentionConfigurationsResponseFetcher();
    }

    public Iterator<DescribeRetentionConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RetentionConfiguration> retentionConfigurations() {
        Function<DescribeRetentionConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.retentionConfigurations() != null) {
                return response.retentionConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRetentionConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeRetentionConfigurationsResponse> {
        private DescribeRetentionConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRetentionConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRetentionConfigurationsResponse nextPage(DescribeRetentionConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRetentionConfigurationsIterable.this.client.describeRetentionConfigurations(DescribeRetentionConfigurationsIterable.this.firstRequest);
            }
            return DescribeRetentionConfigurationsIterable.this.client.describeRetentionConfigurations((DescribeRetentionConfigurationsRequest)((Object)DescribeRetentionConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

