/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRetentionConfigurationsRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeRetentionConfigurationsRequest.Builder, DescribeRetentionConfigurationsRequest> {
    private static final SdkField<List<String>> RETENTION_CONFIGURATION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RetentionConfigurationNames")
            .getter(getter(DescribeRetentionConfigurationsRequest::retentionConfigurationNames))
            .setter(setter(Builder::retentionConfigurationNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionConfigurationNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRetentionConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RETENTION_CONFIGURATION_NAMES_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> retentionConfigurationNames;

    private final String nextToken;

    private DescribeRetentionConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.retentionConfigurationNames = builder.retentionConfigurationNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RetentionConfigurationNames property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRetentionConfigurationNames() {
        return retentionConfigurationNames != null && !(retentionConfigurationNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of retention configurations for which you want details. If you do not specify a name, Config
     * returns details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRetentionConfigurationNames} method.
     * </p>
     * 
     * @return A list of names of retention configurations for which you want details. If you do not specify a name,
     *         Config returns details for all the retention configurations for that account.</p> <note>
     *         <p>
     *         Currently, Config supports only one retention configuration per region in your account.
     *         </p>
     */
    public final List<String> retentionConfigurationNames() {
        return retentionConfigurationNames;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRetentionConfigurationNames() ? retentionConfigurationNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRetentionConfigurationsRequest)) {
            return false;
        }
        DescribeRetentionConfigurationsRequest other = (DescribeRetentionConfigurationsRequest) obj;
        return hasRetentionConfigurationNames() == other.hasRetentionConfigurationNames()
                && Objects.equals(retentionConfigurationNames(), other.retentionConfigurationNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRetentionConfigurationsRequest")
                .add("RetentionConfigurationNames", hasRetentionConfigurationNames() ? retentionConfigurationNames() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionConfigurationNames":
            return Optional.ofNullable(clazz.cast(retentionConfigurationNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRetentionConfigurationsRequest, T> g) {
        return obj -> g.apply((DescribeRetentionConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRetentionConfigurationsRequest> {
        /**
         * <p>
         * A list of names of retention configurations for which you want details. If you do not specify a name, Config
         * returns details for all the retention configurations for that account.
         * </p>
         * <note>
         * <p>
         * Currently, Config supports only one retention configuration per region in your account.
         * </p>
         * </note>
         * 
         * @param retentionConfigurationNames
         *        A list of names of retention configurations for which you want details. If you do not specify a name,
         *        Config returns details for all the retention configurations for that account.</p> <note>
         *        <p>
         *        Currently, Config supports only one retention configuration per region in your account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfigurationNames(Collection<String> retentionConfigurationNames);

        /**
         * <p>
         * A list of names of retention configurations for which you want details. If you do not specify a name, Config
         * returns details for all the retention configurations for that account.
         * </p>
         * <note>
         * <p>
         * Currently, Config supports only one retention configuration per region in your account.
         * </p>
         * </note>
         * 
         * @param retentionConfigurationNames
         *        A list of names of retention configurations for which you want details. If you do not specify a name,
         *        Config returns details for all the retention configurations for that account.</p> <note>
         *        <p>
         *        Currently, Config supports only one retention configuration per region in your account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfigurationNames(String... retentionConfigurationNames);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> retentionConfigurationNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRetentionConfigurationsRequest model) {
            super(model);
            retentionConfigurationNames(model.retentionConfigurationNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getRetentionConfigurationNames() {
            if (retentionConfigurationNames instanceof SdkAutoConstructList) {
                return null;
            }
            return retentionConfigurationNames;
        }

        public final void setRetentionConfigurationNames(Collection<String> retentionConfigurationNames) {
            this.retentionConfigurationNames = RetentionConfigurationNameListCopier.copy(retentionConfigurationNames);
        }

        @Override
        public final Builder retentionConfigurationNames(Collection<String> retentionConfigurationNames) {
            this.retentionConfigurationNames = RetentionConfigurationNameListCopier.copy(retentionConfigurationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionConfigurationNames(String... retentionConfigurationNames) {
            retentionConfigurationNames(Arrays.asList(retentionConfigurationNames));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRetentionConfigurationsRequest build() {
            return new DescribeRetentionConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
