/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ComplianceContributorCount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComplianceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComplianceSummary> {
    private static final SdkField<ComplianceContributorCount> COMPLIANT_RESOURCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompliantResourceCount").getter(ComplianceSummary.getter(ComplianceSummary::compliantResourceCount)).setter(ComplianceSummary.setter(Builder::compliantResourceCount)).constructor(ComplianceContributorCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantResourceCount").build()}).build();
    private static final SdkField<ComplianceContributorCount> NON_COMPLIANT_RESOURCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NonCompliantResourceCount").getter(ComplianceSummary.getter(ComplianceSummary::nonCompliantResourceCount)).setter(ComplianceSummary.setter(Builder::nonCompliantResourceCount)).constructor(ComplianceContributorCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantResourceCount").build()}).build();
    private static final SdkField<Instant> COMPLIANCE_SUMMARY_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ComplianceSummaryTimestamp").getter(ComplianceSummary.getter(ComplianceSummary::complianceSummaryTimestamp)).setter(ComplianceSummary.setter(Builder::complianceSummaryTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummaryTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANT_RESOURCE_COUNT_FIELD, NON_COMPLIANT_RESOURCE_COUNT_FIELD, COMPLIANCE_SUMMARY_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final ComplianceContributorCount compliantResourceCount;
    private final ComplianceContributorCount nonCompliantResourceCount;
    private final Instant complianceSummaryTimestamp;

    private ComplianceSummary(BuilderImpl builder) {
        this.compliantResourceCount = builder.compliantResourceCount;
        this.nonCompliantResourceCount = builder.nonCompliantResourceCount;
        this.complianceSummaryTimestamp = builder.complianceSummaryTimestamp;
    }

    public final ComplianceContributorCount compliantResourceCount() {
        return this.compliantResourceCount;
    }

    public final ComplianceContributorCount nonCompliantResourceCount() {
        return this.nonCompliantResourceCount;
    }

    public final Instant complianceSummaryTimestamp() {
        return this.complianceSummaryTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSummaryTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummary)) {
            return false;
        }
        ComplianceSummary other = (ComplianceSummary)obj;
        return Objects.equals(this.compliantResourceCount(), other.compliantResourceCount()) && Objects.equals(this.nonCompliantResourceCount(), other.nonCompliantResourceCount()) && Objects.equals(this.complianceSummaryTimestamp(), other.complianceSummaryTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ComplianceSummary").add("CompliantResourceCount", (Object)this.compliantResourceCount()).add("NonCompliantResourceCount", (Object)this.nonCompliantResourceCount()).add("ComplianceSummaryTimestamp", (Object)this.complianceSummaryTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompliantResourceCount": {
                return Optional.ofNullable(clazz.cast(this.compliantResourceCount()));
            }
            case "NonCompliantResourceCount": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantResourceCount()));
            }
            case "ComplianceSummaryTimestamp": {
                return Optional.ofNullable(clazz.cast(this.complianceSummaryTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceSummary, T> g) {
        return obj -> g.apply((ComplianceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ComplianceContributorCount compliantResourceCount;
        private ComplianceContributorCount nonCompliantResourceCount;
        private Instant complianceSummaryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummary model) {
            this.compliantResourceCount(model.compliantResourceCount);
            this.nonCompliantResourceCount(model.nonCompliantResourceCount);
            this.complianceSummaryTimestamp(model.complianceSummaryTimestamp);
        }

        public final ComplianceContributorCount.Builder getCompliantResourceCount() {
            return this.compliantResourceCount != null ? this.compliantResourceCount.toBuilder() : null;
        }

        @Override
        public final Builder compliantResourceCount(ComplianceContributorCount compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount;
            return this;
        }

        public final void setCompliantResourceCount(ComplianceContributorCount.BuilderImpl compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount != null ? compliantResourceCount.build() : null;
        }

        public final ComplianceContributorCount.Builder getNonCompliantResourceCount() {
            return this.nonCompliantResourceCount != null ? this.nonCompliantResourceCount.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount;
            return this;
        }

        public final void setNonCompliantResourceCount(ComplianceContributorCount.BuilderImpl nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount != null ? nonCompliantResourceCount.build() : null;
        }

        public final Instant getComplianceSummaryTimestamp() {
            return this.complianceSummaryTimestamp;
        }

        @Override
        public final Builder complianceSummaryTimestamp(Instant complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = complianceSummaryTimestamp;
            return this;
        }

        public final void setComplianceSummaryTimestamp(Instant complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = complianceSummaryTimestamp;
        }

        public ComplianceSummary build() {
            return new ComplianceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComplianceSummary> {
        public Builder compliantResourceCount(ComplianceContributorCount var1);

        default public Builder compliantResourceCount(Consumer<ComplianceContributorCount.Builder> compliantResourceCount) {
            return this.compliantResourceCount((ComplianceContributorCount)((ComplianceContributorCount.Builder)ComplianceContributorCount.builder().applyMutation(compliantResourceCount)).build());
        }

        public Builder nonCompliantResourceCount(ComplianceContributorCount var1);

        default public Builder nonCompliantResourceCount(Consumer<ComplianceContributorCount.Builder> nonCompliantResourceCount) {
            return this.nonCompliantResourceCount((ComplianceContributorCount)((ComplianceContributorCount.Builder)ComplianceContributorCount.builder().applyMutation(nonCompliantResourceCount)).build());
        }

        public Builder complianceSummaryTimestamp(Instant var1);
    }
}

