/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;

public class SelectAggregateResourceConfigIterable
implements SdkIterable<SelectAggregateResourceConfigResponse> {
    private final ConfigClient client;
    private final SelectAggregateResourceConfigRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SelectAggregateResourceConfigIterable(ConfigClient client, SelectAggregateResourceConfigRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SelectAggregateResourceConfigResponseFetcher();
    }

    public Iterator<SelectAggregateResourceConfigResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> results() {
        Function<SelectAggregateResourceConfigResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SelectAggregateResourceConfigResponseFetcher
    implements SyncPageFetcher<SelectAggregateResourceConfigResponse> {
        private SelectAggregateResourceConfigResponseFetcher() {
        }

        public boolean hasNextPage(SelectAggregateResourceConfigResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SelectAggregateResourceConfigResponse nextPage(SelectAggregateResourceConfigResponse previousPage) {
            if (previousPage == null) {
                return SelectAggregateResourceConfigIterable.this.client.selectAggregateResourceConfig(SelectAggregateResourceConfigIterable.this.firstRequest);
            }
            return SelectAggregateResourceConfigIterable.this.client.selectAggregateResourceConfig((SelectAggregateResourceConfigRequest)((Object)SelectAggregateResourceConfigIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

