/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupedResourceCount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupedResourceCount> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(GroupedResourceCount.getter(GroupedResourceCount::groupName)).setter(GroupedResourceCount.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<Long> RESOURCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ResourceCount").getter(GroupedResourceCount.getter(GroupedResourceCount::resourceCount)).setter(GroupedResourceCount.setter(Builder::resourceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, RESOURCE_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final Long resourceCount;

    private GroupedResourceCount(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.resourceCount = builder.resourceCount;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final Long resourceCount() {
        return this.resourceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupedResourceCount)) {
            return false;
        }
        GroupedResourceCount other = (GroupedResourceCount)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.resourceCount(), other.resourceCount());
    }

    public final String toString() {
        return ToString.builder((String)"GroupedResourceCount").add("GroupName", (Object)this.groupName()).add("ResourceCount", (Object)this.resourceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "ResourceCount": {
                return Optional.ofNullable(clazz.cast(this.resourceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupedResourceCount, T> g) {
        return obj -> g.apply((GroupedResourceCount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private Long resourceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupedResourceCount model) {
            this.groupName(model.groupName);
            this.resourceCount(model.resourceCount);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Long getResourceCount() {
            return this.resourceCount;
        }

        @Override
        public final Builder resourceCount(Long resourceCount) {
            this.resourceCount = resourceCount;
            return this;
        }

        public final void setResourceCount(Long resourceCount) {
            this.resourceCount = resourceCount;
        }

        public GroupedResourceCount build() {
            return new GroupedResourceCount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupedResourceCount> {
        public Builder groupName(String var1);

        public Builder resourceCount(Long var1);
    }
}

