/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAggregateComplianceDetailsByConfigRuleRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, GetAggregateComplianceDetailsByConfigRuleRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationAggregatorName").getter(GetAggregateComplianceDetailsByConfigRuleRequest.getter(GetAggregateComplianceDetailsByConfigRuleRequest::configurationAggregatorName)).setter(GetAggregateComplianceDetailsByConfigRuleRequest.setter(Builder::configurationAggregatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName").build()}).build();
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(GetAggregateComplianceDetailsByConfigRuleRequest.getter(GetAggregateComplianceDetailsByConfigRuleRequest::configRuleName)).setter(GetAggregateComplianceDetailsByConfigRuleRequest.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(GetAggregateComplianceDetailsByConfigRuleRequest.getter(GetAggregateComplianceDetailsByConfigRuleRequest::accountId)).setter(GetAggregateComplianceDetailsByConfigRuleRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(GetAggregateComplianceDetailsByConfigRuleRequest.getter(GetAggregateComplianceDetailsByConfigRuleRequest::awsRegion)).setter(GetAggregateComplianceDetailsByConfigRuleRequest.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(GetAggregateComplianceDetailsByConfigRuleRequest.getter(GetAggregateComplianceDetailsByConfigRuleRequest::complianceTypeAsString)).setter(GetAggregateComplianceDetailsByConfigRuleRequest.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(GetAggregateComplianceDetailsByConfigRuleRequest.getter(GetAggregateComplianceDetailsByConfigRuleRequest::limit)).setter(GetAggregateComplianceDetailsByConfigRuleRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetAggregateComplianceDetailsByConfigRuleRequest.getter(GetAggregateComplianceDetailsByConfigRuleRequest::nextToken)).setter(GetAggregateComplianceDetailsByConfigRuleRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_AGGREGATOR_NAME_FIELD, CONFIG_RULE_NAME_FIELD, ACCOUNT_ID_FIELD, AWS_REGION_FIELD, COMPLIANCE_TYPE_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final String configurationAggregatorName;
    private final String configRuleName;
    private final String accountId;
    private final String awsRegion;
    private final String complianceType;
    private final Integer limit;
    private final String nextToken;

    private GetAggregateComplianceDetailsByConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.configRuleName = builder.configRuleName;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
        this.complianceType = builder.complianceType;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String configurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public String accountId() {
        return this.accountId;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public ComplianceType complianceType() {
        return ComplianceType.fromValue(this.complianceType);
    }

    public String complianceTypeAsString() {
        return this.complianceType;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateComplianceDetailsByConfigRuleRequest)) {
            return false;
        }
        GetAggregateComplianceDetailsByConfigRuleRequest other = (GetAggregateComplianceDetailsByConfigRuleRequest)((Object)obj);
        return Objects.equals(this.configurationAggregatorName(), other.configurationAggregatorName()) && Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetAggregateComplianceDetailsByConfigRuleRequest").add("ConfigurationAggregatorName", (Object)this.configurationAggregatorName()).add("ConfigRuleName", (Object)this.configRuleName()).add("AccountId", (Object)this.accountId()).add("AwsRegion", (Object)this.awsRegion()).add("ComplianceType", (Object)this.complianceTypeAsString()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregatorName": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorName()));
            }
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateComplianceDetailsByConfigRuleRequest, T> g) {
        return obj -> g.apply((GetAggregateComplianceDetailsByConfigRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configurationAggregatorName;
        private String configRuleName;
        private String accountId;
        private String awsRegion;
        private String complianceType;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateComplianceDetailsByConfigRuleRequest model) {
            super(model);
            this.configurationAggregatorName(model.configurationAggregatorName);
            this.configRuleName(model.configRuleName);
            this.accountId(model.accountId);
            this.awsRegion(model.awsRegion);
            this.complianceType(model.complianceType);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAggregateComplianceDetailsByConfigRuleRequest build() {
            return new GetAggregateComplianceDetailsByConfigRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAggregateComplianceDetailsByConfigRuleRequest> {
        public Builder configurationAggregatorName(String var1);

        public Builder configRuleName(String var1);

        public Builder accountId(String var1);

        public Builder awsRegion(String var1);

        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

