/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregateResourceIdentifier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.DiscoveredResourceIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAggregateDiscoveredResourcesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, ListAggregateDiscoveredResourcesResponse> {
    private static final SdkField<List<AggregateResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIdentifiers").getter(ListAggregateDiscoveredResourcesResponse.getter(ListAggregateDiscoveredResourcesResponse::resourceIdentifiers)).setter(ListAggregateDiscoveredResourcesResponse.setter(Builder::resourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregateResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAggregateDiscoveredResourcesResponse.getter(ListAggregateDiscoveredResourcesResponse::nextToken)).setter(ListAggregateDiscoveredResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AggregateResourceIdentifier> resourceIdentifiers;
    private final String nextToken;

    private ListAggregateDiscoveredResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public boolean hasResourceIdentifiers() {
        return this.resourceIdentifiers != null && !(this.resourceIdentifiers instanceof SdkAutoConstructList);
    }

    public List<AggregateResourceIdentifier> resourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregateDiscoveredResourcesResponse)) {
            return false;
        }
        ListAggregateDiscoveredResourcesResponse other = (ListAggregateDiscoveredResourcesResponse)((Object)obj);
        return Objects.equals(this.resourceIdentifiers(), other.resourceIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAggregateDiscoveredResourcesResponse").add("ResourceIdentifiers", this.resourceIdentifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAggregateDiscoveredResourcesResponse, T> g) {
        return obj -> g.apply((ListAggregateDiscoveredResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<AggregateResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAggregateDiscoveredResourcesResponse model) {
            super(model);
            this.resourceIdentifiers(model.resourceIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<AggregateResourceIdentifier.Builder> getResourceIdentifiers() {
            return this.resourceIdentifiers != null ? (Collection)this.resourceIdentifiers.stream().map(AggregateResourceIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = DiscoveredResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(AggregateResourceIdentifier ... resourceIdentifiers) {
            this.resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder> ... resourceIdentifiers) {
            this.resourceIdentifiers(Stream.of(resourceIdentifiers).map(c -> (AggregateResourceIdentifier)((AggregateResourceIdentifier.Builder)AggregateResourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceIdentifiers(Collection<AggregateResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = DiscoveredResourceIdentifierListCopier.copyFromBuilder(resourceIdentifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAggregateDiscoveredResourcesResponse build() {
            return new ListAggregateDiscoveredResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAggregateDiscoveredResourcesResponse> {
        public Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> var1);

        public Builder resourceIdentifiers(AggregateResourceIdentifier ... var1);

        public Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

