/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComplianceDetailsByConfigRuleRequest extends ConfigRequest implements
        ToCopyableBuilder<GetComplianceDetailsByConfigRuleRequest.Builder, GetComplianceDetailsByConfigRuleRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetComplianceDetailsByConfigRuleRequest::configRuleName)).setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<List<String>> COMPLIANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetComplianceDetailsByConfigRuleRequest::complianceTypesAsStrings))
            .setter(setter(Builder::complianceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetComplianceDetailsByConfigRuleRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetComplianceDetailsByConfigRuleRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            COMPLIANCE_TYPES_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String configRuleName;

    private final List<String> complianceTypes;

    private final Integer limit;

    private final String nextToken;

    private GetComplianceDetailsByConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.complianceTypes = builder.complianceTypes;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the AWS Config rule for which you want compliance information.
     * </p>
     * 
     * @return The name of the AWS Config rule for which you want compliance information.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComplianceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
     *         <code>NOT_APPLICABLE</code>.
     */
    public List<ComplianceType> complianceTypes() {
        return ComplianceTypesCopier.copyStringToEnum(complianceTypes);
    }

    /**
     * Returns true if the ComplianceTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasComplianceTypes() {
        return complianceTypes != null && !(complianceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComplianceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
     *         <code>NOT_APPLICABLE</code>.
     */
    public List<String> complianceTypesAsStrings() {
        return complianceTypes;
    }

    /**
     * <p>
     * The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number
     * greater than 100. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a
     *         number greater than 100. If you specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByConfigRuleRequest)) {
            return false;
        }
        GetComplianceDetailsByConfigRuleRequest other = (GetComplianceDetailsByConfigRuleRequest) obj;
        return Objects.equals(configRuleName(), other.configRuleName())
                && Objects.equals(complianceTypesAsStrings(), other.complianceTypesAsStrings())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetComplianceDetailsByConfigRuleRequest").add("ConfigRuleName", configRuleName())
                .add("ComplianceTypes", complianceTypesAsStrings()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ComplianceTypes":
            return Optional.ofNullable(clazz.cast(complianceTypesAsStrings()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceDetailsByConfigRuleRequest, T> g) {
        return obj -> g.apply((GetComplianceDetailsByConfigRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetComplianceDetailsByConfigRuleRequest> {
        /**
         * <p>
         * The name of the AWS Config rule for which you want compliance information.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule for which you want compliance information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>NOT_APPLICABLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypesWithStrings(Collection<String> complianceTypes);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>NOT_APPLICABLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypesWithStrings(String... complianceTypes);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>NOT_APPLICABLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypes(Collection<ComplianceType> complianceTypes);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>NOT_APPLICABLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypes(ComplianceType... complianceTypes);

        /**
         * <p>
         * The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a
         * number greater than 100. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of evaluation results returned on each page. The default is 10. You cannot specify
         *        a number greater than 100. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configRuleName;

        private List<String> complianceTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByConfigRuleRequest model) {
            super(model);
            configRuleName(model.configRuleName);
            complianceTypesWithStrings(model.complianceTypes);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Collection<String> getComplianceTypes() {
            return complianceTypes;
        }

        @Override
        public final Builder complianceTypesWithStrings(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypesWithStrings(String... complianceTypes) {
            complianceTypesWithStrings(Arrays.asList(complianceTypes));
            return this;
        }

        @Override
        public final Builder complianceTypes(Collection<ComplianceType> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copyEnumToString(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(ComplianceType... complianceTypes) {
            complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComplianceDetailsByConfigRuleRequest build() {
            return new GetComplianceDetailsByConfigRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
