/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list that contains the status of the delivery of the configuration stream notification to the Amazon SNS topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigStreamDeliveryInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigStreamDeliveryInfo.Builder, ConfigStreamDeliveryInfo> {
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigStreamDeliveryInfo::lastStatusAsString)).setter(setter(Builder::lastStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()).build();

    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigStreamDeliveryInfo::lastErrorCode)).setter(setter(Builder::lastErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorCode").build()).build();

    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigStreamDeliveryInfo::lastErrorMessage)).setter(setter(Builder::lastErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorMessage").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ConfigStreamDeliveryInfo::lastStatusChangeTime)).setter(setter(Builder::lastStatusChangeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChangeTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_STATUS_FIELD,
            LAST_ERROR_CODE_FIELD, LAST_ERROR_MESSAGE_FIELD, LAST_STATUS_CHANGE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lastStatus;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Instant lastStatusChangeTime;

    private ConfigStreamDeliveryInfo(BuilderImpl builder) {
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    /**
     * <p>
     * Status of the last attempted delivery.
     * </p>
     * <p>
     * <b>Note</b> Providing an SNS topic on a <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for
     * AWS Config is optional. If the SNS delivery is turned off, the last status will be <b>Not_Applicable</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link DeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return Status of the last attempted delivery.</p>
     *         <p>
     *         <b>Note</b> Providing an SNS topic on a <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html"
     *         >DeliveryChannel</a> for AWS Config is optional. If the SNS delivery is turned off, the last status will
     *         be <b>Not_Applicable</b>.
     * @see DeliveryStatus
     */
    public DeliveryStatus lastStatus() {
        return DeliveryStatus.fromValue(lastStatus);
    }

    /**
     * <p>
     * Status of the last attempted delivery.
     * </p>
     * <p>
     * <b>Note</b> Providing an SNS topic on a <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for
     * AWS Config is optional. If the SNS delivery is turned off, the last status will be <b>Not_Applicable</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link DeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return Status of the last attempted delivery.</p>
     *         <p>
     *         <b>Note</b> Providing an SNS topic on a <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html"
     *         >DeliveryChannel</a> for AWS Config is optional. If the SNS delivery is turned off, the last status will
     *         be <b>Not_Applicable</b>.
     * @see DeliveryStatus
     */
    public String lastStatusAsString() {
        return lastStatus;
    }

    /**
     * <p>
     * The error code from the last attempted delivery.
     * </p>
     * 
     * @return The error code from the last attempted delivery.
     */
    public String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The error message from the last attempted delivery.
     * </p>
     * 
     * @return The error message from the last attempted delivery.
     */
    public String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * The time from the last status change.
     * </p>
     * 
     * @return The time from the last status change.
     */
    public Instant lastStatusChangeTime() {
        return lastStatusChangeTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChangeTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigStreamDeliveryInfo)) {
            return false;
        }
        ConfigStreamDeliveryInfo other = (ConfigStreamDeliveryInfo) obj;
        return Objects.equals(lastStatusAsString(), other.lastStatusAsString())
                && Objects.equals(lastErrorCode(), other.lastErrorCode())
                && Objects.equals(lastErrorMessage(), other.lastErrorMessage())
                && Objects.equals(lastStatusChangeTime(), other.lastStatusChangeTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfigStreamDeliveryInfo").add("LastStatus", lastStatusAsString())
                .add("LastErrorCode", lastErrorCode()).add("LastErrorMessage", lastErrorMessage())
                .add("LastStatusChangeTime", lastStatusChangeTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastStatus":
            return Optional.ofNullable(clazz.cast(lastStatusAsString()));
        case "lastErrorCode":
            return Optional.ofNullable(clazz.cast(lastErrorCode()));
        case "lastErrorMessage":
            return Optional.ofNullable(clazz.cast(lastErrorMessage()));
        case "lastStatusChangeTime":
            return Optional.ofNullable(clazz.cast(lastStatusChangeTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigStreamDeliveryInfo, T> g) {
        return obj -> g.apply((ConfigStreamDeliveryInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigStreamDeliveryInfo> {
        /**
         * <p>
         * Status of the last attempted delivery.
         * </p>
         * <p>
         * <b>Note</b> Providing an SNS topic on a <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a>
         * for AWS Config is optional. If the SNS delivery is turned off, the last status will be <b>Not_Applicable</b>.
         * </p>
         * 
         * @param lastStatus
         *        Status of the last attempted delivery.</p>
         *        <p>
         *        <b>Note</b> Providing an SNS topic on a <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html"
         *        >DeliveryChannel</a> for AWS Config is optional. If the SNS delivery is turned off, the last status
         *        will be <b>Not_Applicable</b>.
         * @see DeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * Status of the last attempted delivery.
         * </p>
         * <p>
         * <b>Note</b> Providing an SNS topic on a <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a>
         * for AWS Config is optional. If the SNS delivery is turned off, the last status will be <b>Not_Applicable</b>.
         * </p>
         * 
         * @param lastStatus
         *        Status of the last attempted delivery.</p>
         *        <p>
         *        <b>Note</b> Providing an SNS topic on a <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html"
         *        >DeliveryChannel</a> for AWS Config is optional. If the SNS delivery is turned off, the last status
         *        will be <b>Not_Applicable</b>.
         * @see DeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder lastStatus(DeliveryStatus lastStatus);

        /**
         * <p>
         * The error code from the last attempted delivery.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code from the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The error message from the last attempted delivery.
         * </p>
         * 
         * @param lastErrorMessage
         *        The error message from the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * The time from the last status change.
         * </p>
         * 
         * @param lastStatusChangeTime
         *        The time from the last status change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChangeTime(Instant lastStatusChangeTime);
    }

    static final class BuilderImpl implements Builder {
        private String lastStatus;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Instant lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigStreamDeliveryInfo model) {
            lastStatus(model.lastStatus);
            lastErrorCode(model.lastErrorCode);
            lastErrorMessage(model.lastErrorMessage);
            lastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastStatusChangeTime() {
            return lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        @Override
        public ConfigStreamDeliveryInfo build() {
            return new ConfigStreamDeliveryInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
