/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRemediationExceptionsRequest extends ConfigRequest implements
        ToCopyableBuilder<PutRemediationExceptionsRequest.Builder, PutRemediationExceptionsRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutRemediationExceptionsRequest::configRuleName)).setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<List<RemediationExceptionResourceKey>> RESOURCE_KEYS_FIELD = SdkField
            .<List<RemediationExceptionResourceKey>> builder(MarshallingType.LIST)
            .getter(getter(PutRemediationExceptionsRequest::resourceKeys))
            .setter(setter(Builder::resourceKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationExceptionResourceKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationExceptionResourceKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutRemediationExceptionsRequest::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PutRemediationExceptionsRequest::expirationTime)).setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            RESOURCE_KEYS_FIELD, MESSAGE_FIELD, EXPIRATION_TIME_FIELD));

    private final String configRuleName;

    private final List<RemediationExceptionResourceKey> resourceKeys;

    private final String message;

    private final Instant expirationTime;

    private PutRemediationExceptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.resourceKeys = builder.resourceKeys;
        this.message = builder.message;
        this.expirationTime = builder.expirationTime;
    }

    /**
     * <p>
     * The name of the AWS Config rule for which you want to create remediation exception.
     * </p>
     * 
     * @return The name of the AWS Config rule for which you want to create remediation exception.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * Returns true if the ResourceKeys property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceKeys() {
        return resourceKeys != null && !(resourceKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An exception list of resource exception keys to be processed with the current request. AWS Config adds exception
     * for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An exception list of resource exception keys to be processed with the current request. AWS Config adds
     *         exception for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys.
     */
    public List<RemediationExceptionResourceKey> resourceKeys() {
        return resourceKeys;
    }

    /**
     * <p>
     * The message contains an explanation of the exception.
     * </p>
     * 
     * @return The message contains an explanation of the exception.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The exception is automatically deleted after the expiration date.
     * </p>
     * 
     * @return The exception is automatically deleted after the expiration date.
     */
    public Instant expirationTime() {
        return expirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceKeys());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRemediationExceptionsRequest)) {
            return false;
        }
        PutRemediationExceptionsRequest other = (PutRemediationExceptionsRequest) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(resourceKeys(), other.resourceKeys())
                && Objects.equals(message(), other.message()) && Objects.equals(expirationTime(), other.expirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutRemediationExceptionsRequest").add("ConfigRuleName", configRuleName())
                .add("ResourceKeys", resourceKeys()).add("Message", message()).add("ExpirationTime", expirationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ResourceKeys":
            return Optional.ofNullable(clazz.cast(resourceKeys()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRemediationExceptionsRequest, T> g) {
        return obj -> g.apply((PutRemediationExceptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRemediationExceptionsRequest> {
        /**
         * <p>
         * The name of the AWS Config rule for which you want to create remediation exception.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule for which you want to create remediation exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * An exception list of resource exception keys to be processed with the current request. AWS Config adds
         * exception for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys.
         * </p>
         * 
         * @param resourceKeys
         *        An exception list of resource exception keys to be processed with the current request. AWS Config adds
         *        exception for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKeys(Collection<RemediationExceptionResourceKey> resourceKeys);

        /**
         * <p>
         * An exception list of resource exception keys to be processed with the current request. AWS Config adds
         * exception for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys.
         * </p>
         * 
         * @param resourceKeys
         *        An exception list of resource exception keys to be processed with the current request. AWS Config adds
         *        exception for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKeys(RemediationExceptionResourceKey... resourceKeys);

        /**
         * <p>
         * An exception list of resource exception keys to be processed with the current request. AWS Config adds
         * exception for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemediationExceptionResourceKey>.Builder}
         * avoiding the need to create one manually via {@link List<RemediationExceptionResourceKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemediationExceptionResourceKey>.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceKeys(List<RemediationExceptionResourceKey>)}.
         * 
         * @param resourceKeys
         *        a consumer that will call methods on {@link List<RemediationExceptionResourceKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceKeys(List<RemediationExceptionResourceKey>)
         */
        Builder resourceKeys(Consumer<RemediationExceptionResourceKey.Builder>... resourceKeys);

        /**
         * <p>
         * The message contains an explanation of the exception.
         * </p>
         * 
         * @param message
         *        The message contains an explanation of the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The exception is automatically deleted after the expiration date.
         * </p>
         * 
         * @param expirationTime
         *        The exception is automatically deleted after the expiration date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configRuleName;

        private List<RemediationExceptionResourceKey> resourceKeys = DefaultSdkAutoConstructList.getInstance();

        private String message;

        private Instant expirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRemediationExceptionsRequest model) {
            super(model);
            configRuleName(model.configRuleName);
            resourceKeys(model.resourceKeys);
            message(model.message);
            expirationTime(model.expirationTime);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Collection<RemediationExceptionResourceKey.Builder> getResourceKeys() {
            return resourceKeys != null ? resourceKeys.stream().map(RemediationExceptionResourceKey::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceKeys(Collection<RemediationExceptionResourceKey> resourceKeys) {
            this.resourceKeys = RemediationExceptionResourceKeysCopier.copy(resourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(RemediationExceptionResourceKey... resourceKeys) {
            resourceKeys(Arrays.asList(resourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(Consumer<RemediationExceptionResourceKey.Builder>... resourceKeys) {
            resourceKeys(Stream.of(resourceKeys).map(c -> RemediationExceptionResourceKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceKeys(Collection<RemediationExceptionResourceKey.BuilderImpl> resourceKeys) {
            this.resourceKeys = RemediationExceptionResourceKeysCopier.copyFromBuilder(resourceKeys);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRemediationExceptionsRequest build() {
            return new PutRemediationExceptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
