/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRemediationExecutionStatusRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeRemediationExecutionStatusRequest.Builder, DescribeRemediationExecutionStatusRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRemediationExecutionStatusRequest::configRuleName)).setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<List<ResourceKey>> RESOURCE_KEYS_FIELD = SdkField
            .<List<ResourceKey>> builder(MarshallingType.LIST)
            .getter(getter(DescribeRemediationExecutionStatusRequest::resourceKeys))
            .setter(setter(Builder::resourceKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeRemediationExecutionStatusRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRemediationExecutionStatusRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            RESOURCE_KEYS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String configRuleName;

    private final List<ResourceKey> resourceKeys;

    private final Integer limit;

    private final String nextToken;

    private DescribeRemediationExecutionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.resourceKeys = builder.resourceKeys;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of AWS Config rule names.
     * </p>
     * 
     * @return A list of AWS Config rule names.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * Returns true if the ResourceKeys property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceKeys() {
        return resourceKeys != null && !(resourceKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource keys to be processed with the current request. Each element in the list consists of the
     * resource type and resource ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of resource keys to be processed with the current request. Each element in the list consists of
     *         the resource type and resource ID.
     */
    public List<ResourceKey> resourceKeys() {
        return resourceKeys;
    }

    /**
     * <p>
     * The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you specify
     * 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you
     *         specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceKeys());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationExecutionStatusRequest)) {
            return false;
        }
        DescribeRemediationExecutionStatusRequest other = (DescribeRemediationExecutionStatusRequest) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(resourceKeys(), other.resourceKeys())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRemediationExecutionStatusRequest").add("ConfigRuleName", configRuleName())
                .add("ResourceKeys", resourceKeys()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ResourceKeys":
            return Optional.ofNullable(clazz.cast(resourceKeys()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationExecutionStatusRequest, T> g) {
        return obj -> g.apply((DescribeRemediationExecutionStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRemediationExecutionStatusRequest> {
        /**
         * <p>
         * A list of AWS Config rule names.
         * </p>
         * 
         * @param configRuleName
         *        A list of AWS Config rule names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * A list of resource keys to be processed with the current request. Each element in the list consists of the
         * resource type and resource ID.
         * </p>
         * 
         * @param resourceKeys
         *        A list of resource keys to be processed with the current request. Each element in the list consists of
         *        the resource type and resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKeys(Collection<ResourceKey> resourceKeys);

        /**
         * <p>
         * A list of resource keys to be processed with the current request. Each element in the list consists of the
         * resource type and resource ID.
         * </p>
         * 
         * @param resourceKeys
         *        A list of resource keys to be processed with the current request. Each element in the list consists of
         *        the resource type and resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKeys(ResourceKey... resourceKeys);

        /**
         * <p>
         * A list of resource keys to be processed with the current request. Each element in the list consists of the
         * resource type and resource ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceKey>.Builder} avoiding the need to
         * create one manually via {@link List<ResourceKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceKeys(List<ResourceKey>)}.
         * 
         * @param resourceKeys
         *        a consumer that will call methods on {@link List<ResourceKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceKeys(List<ResourceKey>)
         */
        Builder resourceKeys(Consumer<ResourceKey.Builder>... resourceKeys);

        /**
         * <p>
         * The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you
         * specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If
         *        you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configRuleName;

        private List<ResourceKey> resourceKeys = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationExecutionStatusRequest model) {
            super(model);
            configRuleName(model.configRuleName);
            resourceKeys(model.resourceKeys);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Collection<ResourceKey.Builder> getResourceKeys() {
            return resourceKeys != null ? resourceKeys.stream().map(ResourceKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceKeys(Collection<ResourceKey> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copy(resourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(ResourceKey... resourceKeys) {
            resourceKeys(Arrays.asList(resourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(Consumer<ResourceKey.Builder>... resourceKeys) {
            resourceKeys(Stream.of(resourceKeys).map(c -> ResourceKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceKeys(Collection<ResourceKey.BuilderImpl> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copyFromBuilder(resourceKeys);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRemediationExecutionStatusRequest build() {
            return new DescribeRemediationExecutionStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
