/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that identify a resource that is collected by AWS Config aggregator, including the resource type, ID, (if
 * available) the custom resource name, the source account, and source region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateResourceIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateResourceIdentifier.Builder, AggregateResourceIdentifier> {
    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregateResourceIdentifier::sourceAccountId)).setter(setter(Builder::sourceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccountId").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregateResourceIdentifier::sourceRegion)).setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregateResourceIdentifier::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregateResourceIdentifier::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregateResourceIdentifier::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ACCOUNT_ID_FIELD,
            SOURCE_REGION_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceAccountId;

    private final String sourceRegion;

    private final String resourceId;

    private final String resourceType;

    private final String resourceName;

    private AggregateResourceIdentifier(BuilderImpl builder) {
        this.sourceAccountId = builder.sourceAccountId;
        this.sourceRegion = builder.sourceRegion;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceName = builder.resourceName;
    }

    /**
     * <p>
     * The 12-digit account ID of the source account.
     * </p>
     * 
     * @return The 12-digit account ID of the source account.
     */
    public String sourceAccountId() {
        return sourceAccountId;
    }

    /**
     * <p>
     * The source region where data is aggregated.
     * </p>
     * 
     * @return The source region where data is aggregated.
     */
    public String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The ID of the AWS resource.
     * </p>
     * 
     * @return The ID of the AWS resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of the AWS resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the AWS resource.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the AWS resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the AWS resource.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The name of the AWS resource.
     * </p>
     * 
     * @return The name of the AWS resource.
     */
    public String resourceName() {
        return resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateResourceIdentifier)) {
            return false;
        }
        AggregateResourceIdentifier other = (AggregateResourceIdentifier) obj;
        return Objects.equals(sourceAccountId(), other.sourceAccountId()) && Objects.equals(sourceRegion(), other.sourceRegion())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceName(), other.resourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AggregateResourceIdentifier").add("SourceAccountId", sourceAccountId())
                .add("SourceRegion", sourceRegion()).add("ResourceId", resourceId()).add("ResourceType", resourceTypeAsString())
                .add("ResourceName", resourceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceAccountId":
            return Optional.ofNullable(clazz.cast(sourceAccountId()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateResourceIdentifier, T> g) {
        return obj -> g.apply((AggregateResourceIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateResourceIdentifier> {
        /**
         * <p>
         * The 12-digit account ID of the source account.
         * </p>
         * 
         * @param sourceAccountId
         *        The 12-digit account ID of the source account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountId(String sourceAccountId);

        /**
         * <p>
         * The source region where data is aggregated.
         * </p>
         * 
         * @param sourceRegion
         *        The source region where data is aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The ID of the AWS resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of the AWS resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the AWS resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the AWS resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the AWS resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The name of the AWS resource.
         * </p>
         * 
         * @param resourceName
         *        The name of the AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);
    }

    static final class BuilderImpl implements Builder {
        private String sourceAccountId;

        private String sourceRegion;

        private String resourceId;

        private String resourceType;

        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateResourceIdentifier model) {
            sourceAccountId(model.sourceAccountId);
            sourceRegion(model.sourceRegion);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            resourceName(model.resourceName);
        }

        public final String getSourceAccountId() {
            return sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public AggregateResourceIdentifier build() {
            return new AggregateResourceIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
