/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ConfigRuleEvaluationStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigRuleEvaluationStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigRuleEvaluationStatus> {
    private final String configRuleName;
    private final String configRuleArn;
    private final String configRuleId;
    private final Instant lastSuccessfulInvocationTime;
    private final Instant lastFailedInvocationTime;
    private final Instant lastSuccessfulEvaluationTime;
    private final Instant lastFailedEvaluationTime;
    private final Instant firstActivatedTime;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Boolean firstEvaluationStarted;

    private ConfigRuleEvaluationStatus(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.configRuleArn = builder.configRuleArn;
        this.configRuleId = builder.configRuleId;
        this.lastSuccessfulInvocationTime = builder.lastSuccessfulInvocationTime;
        this.lastFailedInvocationTime = builder.lastFailedInvocationTime;
        this.lastSuccessfulEvaluationTime = builder.lastSuccessfulEvaluationTime;
        this.lastFailedEvaluationTime = builder.lastFailedEvaluationTime;
        this.firstActivatedTime = builder.firstActivatedTime;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.firstEvaluationStarted = builder.firstEvaluationStarted;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public String configRuleArn() {
        return this.configRuleArn;
    }

    public String configRuleId() {
        return this.configRuleId;
    }

    public Instant lastSuccessfulInvocationTime() {
        return this.lastSuccessfulInvocationTime;
    }

    public Instant lastFailedInvocationTime() {
        return this.lastFailedInvocationTime;
    }

    public Instant lastSuccessfulEvaluationTime() {
        return this.lastSuccessfulEvaluationTime;
    }

    public Instant lastFailedEvaluationTime() {
        return this.lastFailedEvaluationTime;
    }

    public Instant firstActivatedTime() {
        return this.firstActivatedTime;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Boolean firstEvaluationStarted() {
        return this.firstEvaluationStarted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailedInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailedEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstActivatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstEvaluationStarted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRuleEvaluationStatus)) {
            return false;
        }
        ConfigRuleEvaluationStatus other = (ConfigRuleEvaluationStatus)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.configRuleArn(), other.configRuleArn()) && Objects.equals(this.configRuleId(), other.configRuleId()) && Objects.equals(this.lastSuccessfulInvocationTime(), other.lastSuccessfulInvocationTime()) && Objects.equals(this.lastFailedInvocationTime(), other.lastFailedInvocationTime()) && Objects.equals(this.lastSuccessfulEvaluationTime(), other.lastSuccessfulEvaluationTime()) && Objects.equals(this.lastFailedEvaluationTime(), other.lastFailedEvaluationTime()) && Objects.equals(this.firstActivatedTime(), other.firstActivatedTime()) && Objects.equals(this.lastErrorCode(), other.lastErrorCode()) && Objects.equals(this.lastErrorMessage(), other.lastErrorMessage()) && Objects.equals(this.firstEvaluationStarted(), other.firstEvaluationStarted());
    }

    public String toString() {
        return ToString.builder((String)"ConfigRuleEvaluationStatus").add("ConfigRuleName", (Object)this.configRuleName()).add("ConfigRuleArn", (Object)this.configRuleArn()).add("ConfigRuleId", (Object)this.configRuleId()).add("LastSuccessfulInvocationTime", (Object)this.lastSuccessfulInvocationTime()).add("LastFailedInvocationTime", (Object)this.lastFailedInvocationTime()).add("LastSuccessfulEvaluationTime", (Object)this.lastSuccessfulEvaluationTime()).add("LastFailedEvaluationTime", (Object)this.lastFailedEvaluationTime()).add("FirstActivatedTime", (Object)this.firstActivatedTime()).add("LastErrorCode", (Object)this.lastErrorCode()).add("LastErrorMessage", (Object)this.lastErrorMessage()).add("FirstEvaluationStarted", (Object)this.firstEvaluationStarted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.of(clazz.cast(this.configRuleName()));
            }
            case "ConfigRuleArn": {
                return Optional.of(clazz.cast(this.configRuleArn()));
            }
            case "ConfigRuleId": {
                return Optional.of(clazz.cast(this.configRuleId()));
            }
            case "LastSuccessfulInvocationTime": {
                return Optional.of(clazz.cast(this.lastSuccessfulInvocationTime()));
            }
            case "LastFailedInvocationTime": {
                return Optional.of(clazz.cast(this.lastFailedInvocationTime()));
            }
            case "LastSuccessfulEvaluationTime": {
                return Optional.of(clazz.cast(this.lastSuccessfulEvaluationTime()));
            }
            case "LastFailedEvaluationTime": {
                return Optional.of(clazz.cast(this.lastFailedEvaluationTime()));
            }
            case "FirstActivatedTime": {
                return Optional.of(clazz.cast(this.firstActivatedTime()));
            }
            case "LastErrorCode": {
                return Optional.of(clazz.cast(this.lastErrorCode()));
            }
            case "LastErrorMessage": {
                return Optional.of(clazz.cast(this.lastErrorMessage()));
            }
            case "FirstEvaluationStarted": {
                return Optional.of(clazz.cast(this.firstEvaluationStarted()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigRuleEvaluationStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String configRuleArn;
        private String configRuleId;
        private Instant lastSuccessfulInvocationTime;
        private Instant lastFailedInvocationTime;
        private Instant lastSuccessfulEvaluationTime;
        private Instant lastFailedEvaluationTime;
        private Instant firstActivatedTime;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Boolean firstEvaluationStarted;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRuleEvaluationStatus model) {
            this.configRuleName(model.configRuleName);
            this.configRuleArn(model.configRuleArn);
            this.configRuleId(model.configRuleId);
            this.lastSuccessfulInvocationTime(model.lastSuccessfulInvocationTime);
            this.lastFailedInvocationTime(model.lastFailedInvocationTime);
            this.lastSuccessfulEvaluationTime(model.lastSuccessfulEvaluationTime);
            this.lastFailedEvaluationTime(model.lastFailedEvaluationTime);
            this.firstActivatedTime(model.firstActivatedTime);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.firstEvaluationStarted(model.firstEvaluationStarted);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getConfigRuleArn() {
            return this.configRuleArn;
        }

        @Override
        public final Builder configRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
            return this;
        }

        public final void setConfigRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
        }

        public final String getConfigRuleId() {
            return this.configRuleId;
        }

        @Override
        public final Builder configRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
            return this;
        }

        public final void setConfigRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
        }

        public final Instant getLastSuccessfulInvocationTime() {
            return this.lastSuccessfulInvocationTime;
        }

        @Override
        public final Builder lastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime) {
            this.lastSuccessfulInvocationTime = lastSuccessfulInvocationTime;
            return this;
        }

        public final void setLastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime) {
            this.lastSuccessfulInvocationTime = lastSuccessfulInvocationTime;
        }

        public final Instant getLastFailedInvocationTime() {
            return this.lastFailedInvocationTime;
        }

        @Override
        public final Builder lastFailedInvocationTime(Instant lastFailedInvocationTime) {
            this.lastFailedInvocationTime = lastFailedInvocationTime;
            return this;
        }

        public final void setLastFailedInvocationTime(Instant lastFailedInvocationTime) {
            this.lastFailedInvocationTime = lastFailedInvocationTime;
        }

        public final Instant getLastSuccessfulEvaluationTime() {
            return this.lastSuccessfulEvaluationTime;
        }

        @Override
        public final Builder lastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime) {
            this.lastSuccessfulEvaluationTime = lastSuccessfulEvaluationTime;
            return this;
        }

        public final void setLastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime) {
            this.lastSuccessfulEvaluationTime = lastSuccessfulEvaluationTime;
        }

        public final Instant getLastFailedEvaluationTime() {
            return this.lastFailedEvaluationTime;
        }

        @Override
        public final Builder lastFailedEvaluationTime(Instant lastFailedEvaluationTime) {
            this.lastFailedEvaluationTime = lastFailedEvaluationTime;
            return this;
        }

        public final void setLastFailedEvaluationTime(Instant lastFailedEvaluationTime) {
            this.lastFailedEvaluationTime = lastFailedEvaluationTime;
        }

        public final Instant getFirstActivatedTime() {
            return this.firstActivatedTime;
        }

        @Override
        public final Builder firstActivatedTime(Instant firstActivatedTime) {
            this.firstActivatedTime = firstActivatedTime;
            return this;
        }

        public final void setFirstActivatedTime(Instant firstActivatedTime) {
            this.firstActivatedTime = firstActivatedTime;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Boolean getFirstEvaluationStarted() {
            return this.firstEvaluationStarted;
        }

        @Override
        public final Builder firstEvaluationStarted(Boolean firstEvaluationStarted) {
            this.firstEvaluationStarted = firstEvaluationStarted;
            return this;
        }

        public final void setFirstEvaluationStarted(Boolean firstEvaluationStarted) {
            this.firstEvaluationStarted = firstEvaluationStarted;
        }

        public ConfigRuleEvaluationStatus build() {
            return new ConfigRuleEvaluationStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigRuleEvaluationStatus> {
        public Builder configRuleName(String var1);

        public Builder configRuleArn(String var1);

        public Builder configRuleId(String var1);

        public Builder lastSuccessfulInvocationTime(Instant var1);

        public Builder lastFailedInvocationTime(Instant var1);

        public Builder lastSuccessfulEvaluationTime(Instant var1);

        public Builder lastFailedEvaluationTime(Instant var1);

        public Builder firstActivatedTime(Instant var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder firstEvaluationStarted(Boolean var1);
    }
}

