/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigurationItemStatus;
import software.amazon.awssdk.services.config.model.RelatedEventListCopier;
import software.amazon.awssdk.services.config.model.Relationship;
import software.amazon.awssdk.services.config.model.RelationshipListCopier;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.model.SupplementaryConfigurationCopier;
import software.amazon.awssdk.services.config.model.TagsCopier;
import software.amazon.awssdk.services.config.transform.ConfigurationItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationItem
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigurationItem> {
    private final String version;
    private final String accountId;
    private final Instant configurationItemCaptureTime;
    private final String configurationItemStatus;
    private final String configurationStateId;
    private final String configurationItemMD5Hash;
    private final String arn;
    private final String resourceType;
    private final String resourceId;
    private final String resourceName;
    private final String awsRegion;
    private final String availabilityZone;
    private final Instant resourceCreationTime;
    private final Map<String, String> tags;
    private final List<String> relatedEvents;
    private final List<Relationship> relationships;
    private final String configuration;
    private final Map<String, String> supplementaryConfiguration;

    private ConfigurationItem(BuilderImpl builder) {
        this.version = builder.version;
        this.accountId = builder.accountId;
        this.configurationItemCaptureTime = builder.configurationItemCaptureTime;
        this.configurationItemStatus = builder.configurationItemStatus;
        this.configurationStateId = builder.configurationStateId;
        this.configurationItemMD5Hash = builder.configurationItemMD5Hash;
        this.arn = builder.arn;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.awsRegion = builder.awsRegion;
        this.availabilityZone = builder.availabilityZone;
        this.resourceCreationTime = builder.resourceCreationTime;
        this.tags = builder.tags;
        this.relatedEvents = builder.relatedEvents;
        this.relationships = builder.relationships;
        this.configuration = builder.configuration;
        this.supplementaryConfiguration = builder.supplementaryConfiguration;
    }

    public String version() {
        return this.version;
    }

    public String accountId() {
        return this.accountId;
    }

    public Instant configurationItemCaptureTime() {
        return this.configurationItemCaptureTime;
    }

    public ConfigurationItemStatus configurationItemStatus() {
        return ConfigurationItemStatus.fromValue(this.configurationItemStatus);
    }

    public String configurationItemStatusString() {
        return this.configurationItemStatus;
    }

    public String configurationStateId() {
        return this.configurationStateId;
    }

    public String configurationItemMD5Hash() {
        return this.configurationItemMD5Hash;
    }

    public String arn() {
        return this.arn;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Instant resourceCreationTime() {
        return this.resourceCreationTime;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public List<String> relatedEvents() {
        return this.relatedEvents;
    }

    public List<Relationship> relationships() {
        return this.relationships;
    }

    public String configuration() {
        return this.configuration;
    }

    public Map<String, String> supplementaryConfiguration() {
        return this.supplementaryConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemCaptureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemMD5Hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationships());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplementaryConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationItem)) {
            return false;
        }
        ConfigurationItem other = (ConfigurationItem)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.configurationItemCaptureTime(), other.configurationItemCaptureTime()) && Objects.equals(this.configurationItemStatusString(), other.configurationItemStatusString()) && Objects.equals(this.configurationStateId(), other.configurationStateId()) && Objects.equals(this.configurationItemMD5Hash(), other.configurationItemMD5Hash()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.resourceTypeString(), other.resourceTypeString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.resourceCreationTime(), other.resourceCreationTime()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.relatedEvents(), other.relatedEvents()) && Objects.equals(this.relationships(), other.relationships()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.supplementaryConfiguration(), other.supplementaryConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.configurationItemCaptureTime() != null) {
            sb.append("ConfigurationItemCaptureTime: ").append(this.configurationItemCaptureTime()).append(",");
        }
        if (this.configurationItemStatusString() != null) {
            sb.append("ConfigurationItemStatus: ").append(this.configurationItemStatusString()).append(",");
        }
        if (this.configurationStateId() != null) {
            sb.append("ConfigurationStateId: ").append(this.configurationStateId()).append(",");
        }
        if (this.configurationItemMD5Hash() != null) {
            sb.append("ConfigurationItemMD5Hash: ").append(this.configurationItemMD5Hash()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.awsRegion() != null) {
            sb.append("AwsRegion: ").append(this.awsRegion()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.resourceCreationTime() != null) {
            sb.append("ResourceCreationTime: ").append(this.resourceCreationTime()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.relatedEvents() != null) {
            sb.append("RelatedEvents: ").append(this.relatedEvents()).append(",");
        }
        if (this.relationships() != null) {
            sb.append("Relationships: ").append(this.relationships()).append(",");
        }
        if (this.configuration() != null) {
            sb.append("Configuration: ").append(this.configuration()).append(",");
        }
        if (this.supplementaryConfiguration() != null) {
            sb.append("SupplementaryConfiguration: ").append(this.supplementaryConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "configurationItemCaptureTime": {
                return Optional.of(clazz.cast(this.configurationItemCaptureTime()));
            }
            case "configurationItemStatus": {
                return Optional.of(clazz.cast(this.configurationItemStatusString()));
            }
            case "configurationStateId": {
                return Optional.of(clazz.cast(this.configurationStateId()));
            }
            case "configurationItemMD5Hash": {
                return Optional.of(clazz.cast(this.configurationItemMD5Hash()));
            }
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "resourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "resourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "awsRegion": {
                return Optional.of(clazz.cast(this.awsRegion()));
            }
            case "availabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "resourceCreationTime": {
                return Optional.of(clazz.cast(this.resourceCreationTime()));
            }
            case "tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "relatedEvents": {
                return Optional.of(clazz.cast(this.relatedEvents()));
            }
            case "relationships": {
                return Optional.of(clazz.cast(this.relationships()));
            }
            case "configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
            case "supplementaryConfiguration": {
                return Optional.of(clazz.cast(this.supplementaryConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private String accountId;
        private Instant configurationItemCaptureTime;
        private String configurationItemStatus;
        private String configurationStateId;
        private String configurationItemMD5Hash;
        private String arn;
        private String resourceType;
        private String resourceId;
        private String resourceName;
        private String awsRegion;
        private String availabilityZone;
        private Instant resourceCreationTime;
        private Map<String, String> tags;
        private List<String> relatedEvents;
        private List<Relationship> relationships;
        private String configuration;
        private Map<String, String> supplementaryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationItem model) {
            this.version(model.version);
            this.accountId(model.accountId);
            this.configurationItemCaptureTime(model.configurationItemCaptureTime);
            this.configurationItemStatus(model.configurationItemStatus);
            this.configurationStateId(model.configurationStateId);
            this.configurationItemMD5Hash(model.configurationItemMD5Hash);
            this.arn(model.arn);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceName(model.resourceName);
            this.awsRegion(model.awsRegion);
            this.availabilityZone(model.availabilityZone);
            this.resourceCreationTime(model.resourceCreationTime);
            this.tags(model.tags);
            this.relatedEvents(model.relatedEvents);
            this.relationships(model.relationships);
            this.configuration(model.configuration);
            this.supplementaryConfiguration(model.supplementaryConfiguration);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Instant getConfigurationItemCaptureTime() {
            return this.configurationItemCaptureTime;
        }

        @Override
        public final Builder configurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
            return this;
        }

        public final void setConfigurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
        }

        public final String getConfigurationItemStatus() {
            return this.configurationItemStatus;
        }

        @Override
        public final Builder configurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
            return this;
        }

        @Override
        public final Builder configurationItemStatus(ConfigurationItemStatus configurationItemStatus) {
            this.configurationItemStatus(configurationItemStatus.toString());
            return this;
        }

        public final void setConfigurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
        }

        public final String getConfigurationStateId() {
            return this.configurationStateId;
        }

        @Override
        public final Builder configurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
            return this;
        }

        public final void setConfigurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
        }

        public final String getConfigurationItemMD5Hash() {
            return this.configurationItemMD5Hash;
        }

        @Override
        public final Builder configurationItemMD5Hash(String configurationItemMD5Hash) {
            this.configurationItemMD5Hash = configurationItemMD5Hash;
            return this;
        }

        public final void setConfigurationItemMD5Hash(String configurationItemMD5Hash) {
            this.configurationItemMD5Hash = configurationItemMD5Hash;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getResourceCreationTime() {
            return this.resourceCreationTime;
        }

        @Override
        public final Builder resourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
            return this;
        }

        public final void setResourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<String> getRelatedEvents() {
            return this.relatedEvents;
        }

        @Override
        public final Builder relatedEvents(Collection<String> relatedEvents) {
            this.relatedEvents = RelatedEventListCopier.copy(relatedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedEvents(String ... relatedEvents) {
            this.relatedEvents(Arrays.asList(relatedEvents));
            return this;
        }

        public final void setRelatedEvents(Collection<String> relatedEvents) {
            this.relatedEvents = RelatedEventListCopier.copy(relatedEvents);
        }

        public final Collection<Relationship.Builder> getRelationships() {
            return this.relationships != null ? (Collection)this.relationships.stream().map(Relationship::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relationships(Collection<Relationship> relationships) {
            this.relationships = RelationshipListCopier.copy(relationships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(Relationship ... relationships) {
            this.relationships(Arrays.asList(relationships));
            return this;
        }

        public final void setRelationships(Collection<Relationship.BuilderImpl> relationships) {
            this.relationships = RelationshipListCopier.copyFromBuilder(relationships);
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public final Map<String, String> getSupplementaryConfiguration() {
            return this.supplementaryConfiguration;
        }

        @Override
        public final Builder supplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
            return this;
        }

        public final void setSupplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
        }

        public ConfigurationItem build() {
            return new ConfigurationItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationItem> {
        public Builder version(String var1);

        public Builder accountId(String var1);

        public Builder configurationItemCaptureTime(Instant var1);

        public Builder configurationItemStatus(String var1);

        public Builder configurationItemStatus(ConfigurationItemStatus var1);

        public Builder configurationStateId(String var1);

        public Builder configurationItemMD5Hash(String var1);

        public Builder arn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceName(String var1);

        public Builder awsRegion(String var1);

        public Builder availabilityZone(String var1);

        public Builder resourceCreationTime(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder relatedEvents(Collection<String> var1);

        public Builder relatedEvents(String ... var1);

        public Builder relationships(Collection<Relationship> var1);

        public Builder relationships(Relationship ... var1);

        public Builder configuration(String var1);

        public Builder supplementaryConfiguration(Map<String, String> var1);
    }
}

