/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.Owner;
import software.amazon.awssdk.services.config.model.SourceDetail;
import software.amazon.awssdk.services.config.model.SourceDetailsCopier;
import software.amazon.awssdk.services.config.transform.SourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Source
implements StructuredPojo,
ToCopyableBuilder<Builder, Source> {
    private final String owner;
    private final String sourceIdentifier;
    private final List<SourceDetail> sourceDetails;

    private Source(BuilderImpl builder) {
        this.owner = builder.owner;
        this.sourceIdentifier = builder.sourceIdentifier;
        this.sourceDetails = builder.sourceDetails;
    }

    public Owner owner() {
        return Owner.fromValue(this.owner);
    }

    public String ownerString() {
        return this.owner;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public List<SourceDetail> sourceDetails() {
        return this.sourceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ownerString() == null ? 0 : this.ownerString().hashCode());
        hashCode = 31 * hashCode + (this.sourceIdentifier() == null ? 0 : this.sourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.sourceDetails() == null ? 0 : this.sourceDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        if (other.ownerString() == null ^ this.ownerString() == null) {
            return false;
        }
        if (other.ownerString() != null && !other.ownerString().equals(this.ownerString())) {
            return false;
        }
        if (other.sourceIdentifier() == null ^ this.sourceIdentifier() == null) {
            return false;
        }
        if (other.sourceIdentifier() != null && !other.sourceIdentifier().equals(this.sourceIdentifier())) {
            return false;
        }
        if (other.sourceDetails() == null ^ this.sourceDetails() == null) {
            return false;
        }
        return other.sourceDetails() == null || other.sourceDetails().equals(this.sourceDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ownerString() != null) {
            sb.append("Owner: ").append(this.ownerString()).append(",");
        }
        if (this.sourceIdentifier() != null) {
            sb.append("SourceIdentifier: ").append(this.sourceIdentifier()).append(",");
        }
        if (this.sourceDetails() != null) {
            sb.append("SourceDetails: ").append(this.sourceDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Owner": {
                return Optional.of(clazz.cast(this.ownerString()));
            }
            case "SourceIdentifier": {
                return Optional.of(clazz.cast(this.sourceIdentifier()));
            }
            case "SourceDetails": {
                return Optional.of(clazz.cast(this.sourceDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String owner;
        private String sourceIdentifier;
        private List<SourceDetail> sourceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.owner(model.owner);
            this.sourceIdentifier(model.sourceIdentifier);
            this.sourceDetails(model.sourceDetails);
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner.toString());
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public final Collection<SourceDetail.Builder> getSourceDetails() {
            return this.sourceDetails != null ? (Collection)this.sourceDetails.stream().map(SourceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourceDetails(Collection<SourceDetail> sourceDetails) {
            this.sourceDetails = SourceDetailsCopier.copy(sourceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDetails(SourceDetail ... sourceDetails) {
            this.sourceDetails(Arrays.asList(sourceDetails));
            return this;
        }

        public final void setSourceDetails(Collection<SourceDetail.BuilderImpl> sourceDetails) {
            this.sourceDetails = SourceDetailsCopier.copyFromBuilder(sourceDetails);
        }

        public Source build() {
            return new Source(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Source> {
        public Builder owner(String var1);

        public Builder owner(Owner var1);

        public Builder sourceIdentifier(String var1);

        public Builder sourceDetails(Collection<SourceDetail> var1);

        public Builder sourceDetails(SourceDetail ... var1);
    }
}

