/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceResourceTypesCopier;
import software.amazon.awssdk.services.config.transform.ScopeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Scope
implements StructuredPojo,
ToCopyableBuilder<Builder, Scope> {
    private final List<String> complianceResourceTypes;
    private final String tagKey;
    private final String tagValue;
    private final String complianceResourceId;

    private Scope(BuilderImpl builder) {
        this.complianceResourceTypes = builder.complianceResourceTypes;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.complianceResourceId = builder.complianceResourceId;
    }

    public List<String> complianceResourceTypes() {
        return this.complianceResourceTypes;
    }

    public String tagKey() {
        return this.tagKey;
    }

    public String tagValue() {
        return this.tagValue;
    }

    public String complianceResourceId() {
        return this.complianceResourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.complianceResourceTypes() == null ? 0 : this.complianceResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.tagKey() == null ? 0 : this.tagKey().hashCode());
        hashCode = 31 * hashCode + (this.tagValue() == null ? 0 : this.tagValue().hashCode());
        hashCode = 31 * hashCode + (this.complianceResourceId() == null ? 0 : this.complianceResourceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)obj;
        if (other.complianceResourceTypes() == null ^ this.complianceResourceTypes() == null) {
            return false;
        }
        if (other.complianceResourceTypes() != null && !other.complianceResourceTypes().equals(this.complianceResourceTypes())) {
            return false;
        }
        if (other.tagKey() == null ^ this.tagKey() == null) {
            return false;
        }
        if (other.tagKey() != null && !other.tagKey().equals(this.tagKey())) {
            return false;
        }
        if (other.tagValue() == null ^ this.tagValue() == null) {
            return false;
        }
        if (other.tagValue() != null && !other.tagValue().equals(this.tagValue())) {
            return false;
        }
        if (other.complianceResourceId() == null ^ this.complianceResourceId() == null) {
            return false;
        }
        return other.complianceResourceId() == null || other.complianceResourceId().equals(this.complianceResourceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.complianceResourceTypes() != null) {
            sb.append("ComplianceResourceTypes: ").append(this.complianceResourceTypes()).append(",");
        }
        if (this.tagKey() != null) {
            sb.append("TagKey: ").append(this.tagKey()).append(",");
        }
        if (this.tagValue() != null) {
            sb.append("TagValue: ").append(this.tagValue()).append(",");
        }
        if (this.complianceResourceId() != null) {
            sb.append("ComplianceResourceId: ").append(this.complianceResourceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceResourceTypes": {
                return Optional.of(clazz.cast(this.complianceResourceTypes()));
            }
            case "TagKey": {
                return Optional.of(clazz.cast(this.tagKey()));
            }
            case "TagValue": {
                return Optional.of(clazz.cast(this.tagValue()));
            }
            case "ComplianceResourceId": {
                return Optional.of(clazz.cast(this.complianceResourceId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScopeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> complianceResourceTypes;
        private String tagKey;
        private String tagValue;
        private String complianceResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(Scope model) {
            this.complianceResourceTypes(model.complianceResourceTypes);
            this.tagKey(model.tagKey);
            this.tagValue(model.tagValue);
            this.complianceResourceId(model.complianceResourceId);
        }

        public final Collection<String> getComplianceResourceTypes() {
            return this.complianceResourceTypes;
        }

        @Override
        public final Builder complianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ComplianceResourceTypesCopier.copy(complianceResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceResourceTypes(String ... complianceResourceTypes) {
            this.complianceResourceTypes(Arrays.asList(complianceResourceTypes));
            return this;
        }

        public final void setComplianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ComplianceResourceTypesCopier.copy(complianceResourceTypes);
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getTagValue() {
            return this.tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        public final String getComplianceResourceId() {
            return this.complianceResourceId;
        }

        @Override
        public final Builder complianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
            return this;
        }

        public final void setComplianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
        }

        public Scope build() {
            return new Scope(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Scope> {
        public Builder complianceResourceTypes(Collection<String> var1);

        public Builder complianceResourceTypes(String ... var1);

        public Builder tagKey(String var1);

        public Builder tagValue(String var1);

        public Builder complianceResourceId(String var1);
    }
}

