/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.Compliance;
import software.amazon.awssdk.services.config.transform.ComplianceByResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceByResource
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceByResource> {
    private final String resourceType;
    private final String resourceId;
    private final Compliance compliance;

    private ComplianceByResource(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.compliance = builder.compliance;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Compliance compliance() {
        return this.compliance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.compliance() == null ? 0 : this.compliance().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceByResource)) {
            return false;
        }
        ComplianceByResource other = (ComplianceByResource)obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.compliance() == null ^ this.compliance() == null) {
            return false;
        }
        return other.compliance() == null || other.compliance().equals(this.compliance());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.compliance() != null) {
            sb.append("Compliance: ").append(this.compliance()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "Compliance": {
                return Optional.of(clazz.cast(this.compliance()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceByResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private Compliance compliance;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceByResource model) {
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.compliance(model.compliance);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Compliance.Builder getCompliance() {
            return this.compliance != null ? this.compliance.toBuilder() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        public ComplianceByResource build() {
            return new ComplianceByResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceByResource> {
        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder compliance(Compliance var1);
    }
}

