/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.Compliance;
import software.amazon.awssdk.services.config.transform.ComplianceByConfigRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceByConfigRule
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceByConfigRule> {
    private final String configRuleName;
    private final Compliance compliance;

    private ComplianceByConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.compliance = builder.compliance;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public Compliance compliance() {
        return this.compliance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configRuleName() == null ? 0 : this.configRuleName().hashCode());
        hashCode = 31 * hashCode + (this.compliance() == null ? 0 : this.compliance().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceByConfigRule)) {
            return false;
        }
        ComplianceByConfigRule other = (ComplianceByConfigRule)obj;
        if (other.configRuleName() == null ^ this.configRuleName() == null) {
            return false;
        }
        if (other.configRuleName() != null && !other.configRuleName().equals(this.configRuleName())) {
            return false;
        }
        if (other.compliance() == null ^ this.compliance() == null) {
            return false;
        }
        return other.compliance() == null || other.compliance().equals(this.compliance());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.configRuleName() != null) {
            sb.append("ConfigRuleName: ").append(this.configRuleName()).append(",");
        }
        if (this.compliance() != null) {
            sb.append("Compliance: ").append(this.compliance()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.of(clazz.cast(this.configRuleName()));
            }
            case "Compliance": {
                return Optional.of(clazz.cast(this.compliance()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceByConfigRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private Compliance compliance;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceByConfigRule model) {
            this.configRuleName(model.configRuleName);
            this.compliance(model.compliance);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Compliance.Builder getCompliance() {
            return this.compliance != null ? this.compliance.toBuilder() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        public ComplianceByConfigRule build() {
            return new ComplianceByConfigRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceByConfigRule> {
        public Builder configRuleName(String var1);

        public Builder compliance(Compliance var1);
    }
}

