/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ComplianceTypesCopier;
import software.amazon.awssdk.services.config.model.ConfigRuleNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeComplianceByConfigRuleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeComplianceByConfigRuleRequest> {
    private final List<String> configRuleNames;
    private final List<String> complianceTypes;
    private final String nextToken;

    private DescribeComplianceByConfigRuleRequest(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
        this.complianceTypes = builder.complianceTypes;
        this.nextToken = builder.nextToken;
    }

    public List<String> configRuleNames() {
        return this.configRuleNames;
    }

    public List<String> complianceTypes() {
        return this.complianceTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configRuleNames() == null ? 0 : this.configRuleNames().hashCode());
        hashCode = 31 * hashCode + (this.complianceTypes() == null ? 0 : this.complianceTypes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByConfigRuleRequest)) {
            return false;
        }
        DescribeComplianceByConfigRuleRequest other = (DescribeComplianceByConfigRuleRequest)((Object)obj);
        if (other.configRuleNames() == null ^ this.configRuleNames() == null) {
            return false;
        }
        if (other.configRuleNames() != null && !other.configRuleNames().equals(this.configRuleNames())) {
            return false;
        }
        if (other.complianceTypes() == null ^ this.complianceTypes() == null) {
            return false;
        }
        if (other.complianceTypes() != null && !other.complianceTypes().equals(this.complianceTypes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configRuleNames() != null) {
            sb.append("ConfigRuleNames: ").append(this.configRuleNames()).append(",");
        }
        if (this.complianceTypes() != null) {
            sb.append("ComplianceTypes: ").append(this.complianceTypes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> configRuleNames;
        private List<String> complianceTypes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByConfigRuleRequest model) {
            this.setConfigRuleNames(model.configRuleNames);
            this.setComplianceTypes(model.complianceTypes);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getConfigRuleNames() {
            return this.configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String ... configRuleNames) {
            this.configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final Collection<String> getComplianceTypes() {
            return this.complianceTypes;
        }

        @Override
        public final Builder complianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(String ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(ComplianceType ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeComplianceByConfigRuleRequest build() {
            return new DescribeComplianceByConfigRuleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeComplianceByConfigRuleRequest> {
        public Builder configRuleNames(Collection<String> var1);

        public Builder configRuleNames(String ... var1);

        public Builder complianceTypes(Collection<String> var1);

        public Builder complianceTypes(String ... var1);

        public Builder complianceTypes(ComplianceType ... var1);

        public Builder nextToken(String var1);
    }
}

