/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.model.ResourceIdentifier;

public class ResourceIdentifierUnmarshaller
implements Unmarshaller<ResourceIdentifier, JsonUnmarshallerContext> {
    private static ResourceIdentifierUnmarshaller INSTANCE;

    public ResourceIdentifier unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceIdentifier.Builder resourceIdentifierBuilder = ResourceIdentifier.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    resourceIdentifierBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceId", targetDepth)) {
                    context.nextToken();
                    resourceIdentifierBuilder.resourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceName", targetDepth)) {
                    context.nextToken();
                    resourceIdentifierBuilder.resourceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceDeletionTime", targetDepth)) {
                    context.nextToken();
                    resourceIdentifierBuilder.resourceDeletionTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceIdentifier)resourceIdentifierBuilder.build();
    }

    public static ResourceIdentifierUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourceIdentifierUnmarshaller();
        }
        return INSTANCE;
    }
}

