/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.EvaluationResultIdentifier;
import software.amazon.awssdk.services.config.transform.EvaluationResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EvaluationResult
implements StructuredPojo,
ToCopyableBuilder<Builder, EvaluationResult> {
    private final EvaluationResultIdentifier evaluationResultIdentifier;
    private final String complianceType;
    private final Instant resultRecordedTime;
    private final Instant configRuleInvokedTime;
    private final String annotation;
    private final String resultToken;

    private EvaluationResult(BuilderImpl builder) {
        this.evaluationResultIdentifier = builder.evaluationResultIdentifier;
        this.complianceType = builder.complianceType;
        this.resultRecordedTime = builder.resultRecordedTime;
        this.configRuleInvokedTime = builder.configRuleInvokedTime;
        this.annotation = builder.annotation;
        this.resultToken = builder.resultToken;
    }

    public EvaluationResultIdentifier evaluationResultIdentifier() {
        return this.evaluationResultIdentifier;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public Instant resultRecordedTime() {
        return this.resultRecordedTime;
    }

    public Instant configRuleInvokedTime() {
        return this.configRuleInvokedTime;
    }

    public String annotation() {
        return this.annotation;
    }

    public String resultToken() {
        return this.resultToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.evaluationResultIdentifier() == null ? 0 : this.evaluationResultIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.complianceType() == null ? 0 : this.complianceType().hashCode());
        hashCode = 31 * hashCode + (this.resultRecordedTime() == null ? 0 : this.resultRecordedTime().hashCode());
        hashCode = 31 * hashCode + (this.configRuleInvokedTime() == null ? 0 : this.configRuleInvokedTime().hashCode());
        hashCode = 31 * hashCode + (this.annotation() == null ? 0 : this.annotation().hashCode());
        hashCode = 31 * hashCode + (this.resultToken() == null ? 0 : this.resultToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        if (other.evaluationResultIdentifier() == null ^ this.evaluationResultIdentifier() == null) {
            return false;
        }
        if (other.evaluationResultIdentifier() != null && !other.evaluationResultIdentifier().equals(this.evaluationResultIdentifier())) {
            return false;
        }
        if (other.complianceType() == null ^ this.complianceType() == null) {
            return false;
        }
        if (other.complianceType() != null && !other.complianceType().equals(this.complianceType())) {
            return false;
        }
        if (other.resultRecordedTime() == null ^ this.resultRecordedTime() == null) {
            return false;
        }
        if (other.resultRecordedTime() != null && !other.resultRecordedTime().equals(this.resultRecordedTime())) {
            return false;
        }
        if (other.configRuleInvokedTime() == null ^ this.configRuleInvokedTime() == null) {
            return false;
        }
        if (other.configRuleInvokedTime() != null && !other.configRuleInvokedTime().equals(this.configRuleInvokedTime())) {
            return false;
        }
        if (other.annotation() == null ^ this.annotation() == null) {
            return false;
        }
        if (other.annotation() != null && !other.annotation().equals(this.annotation())) {
            return false;
        }
        if (other.resultToken() == null ^ this.resultToken() == null) {
            return false;
        }
        return other.resultToken() == null || other.resultToken().equals(this.resultToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.evaluationResultIdentifier() != null) {
            sb.append("EvaluationResultIdentifier: ").append(this.evaluationResultIdentifier()).append(",");
        }
        if (this.complianceType() != null) {
            sb.append("ComplianceType: ").append(this.complianceType()).append(",");
        }
        if (this.resultRecordedTime() != null) {
            sb.append("ResultRecordedTime: ").append(this.resultRecordedTime()).append(",");
        }
        if (this.configRuleInvokedTime() != null) {
            sb.append("ConfigRuleInvokedTime: ").append(this.configRuleInvokedTime()).append(",");
        }
        if (this.annotation() != null) {
            sb.append("Annotation: ").append(this.annotation()).append(",");
        }
        if (this.resultToken() != null) {
            sb.append("ResultToken: ").append(this.resultToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private EvaluationResultIdentifier evaluationResultIdentifier;
        private String complianceType;
        private Instant resultRecordedTime;
        private Instant configRuleInvokedTime;
        private String annotation;
        private String resultToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            this.setEvaluationResultIdentifier(model.evaluationResultIdentifier);
            this.setComplianceType(model.complianceType);
            this.setResultRecordedTime(model.resultRecordedTime);
            this.setConfigRuleInvokedTime(model.configRuleInvokedTime);
            this.setAnnotation(model.annotation);
            this.setResultToken(model.resultToken);
        }

        public final EvaluationResultIdentifier getEvaluationResultIdentifier() {
            return this.evaluationResultIdentifier;
        }

        @Override
        public final Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
            return this;
        }

        public final void setEvaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final void setComplianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
        }

        public final Instant getResultRecordedTime() {
            return this.resultRecordedTime;
        }

        @Override
        public final Builder resultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
            return this;
        }

        public final void setResultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
        }

        public final Instant getConfigRuleInvokedTime() {
            return this.configRuleInvokedTime;
        }

        @Override
        public final Builder configRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
            return this;
        }

        public final void setConfigRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
        }

        public final String getAnnotation() {
            return this.annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public final String getResultToken() {
            return this.resultToken;
        }

        @Override
        public final Builder resultToken(String resultToken) {
            this.resultToken = resultToken;
            return this;
        }

        public final void setResultToken(String resultToken) {
            this.resultToken = resultToken;
        }

        public EvaluationResult build() {
            return new EvaluationResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EvaluationResult> {
        public Builder evaluationResultIdentifier(EvaluationResultIdentifier var1);

        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder resultRecordedTime(Instant var1);

        public Builder configRuleInvokedTime(Instant var1);

        public Builder annotation(String var1);

        public Builder resultToken(String var1);
    }
}

