/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeComplianceByResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").isBinary(false).build();
    private static final MarshallingInfo<List> COMPLIANCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceTypes").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final DescribeComplianceByResourceRequestModelMarshaller INSTANCE = new DescribeComplianceByResourceRequestModelMarshaller();

    private DescribeComplianceByResourceRequestModelMarshaller() {
    }

    public static DescribeComplianceByResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeComplianceByResourceRequest describeComplianceByResourceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeComplianceByResourceRequest), (String)"describeComplianceByResourceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeComplianceByResourceRequest.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)describeComplianceByResourceRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(describeComplianceByResourceRequest.complianceTypesAsStrings(), COMPLIANCETYPES_BINDING);
            protocolMarshaller.marshall((Object)describeComplianceByResourceRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)describeComplianceByResourceRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

