/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigurationAggregator;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationAggregatorMarshaller {
    private static final MarshallingInfo<String> CONFIGURATIONAGGREGATORNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationAggregatorName").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONAGGREGATORARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationAggregatorArn").isBinary(false).build();
    private static final MarshallingInfo<List> ACCOUNTAGGREGATIONSOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountAggregationSources").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ORGANIZATIONAGGREGATIONSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationAggregationSource").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTime").isBinary(false).build();
    private static final ConfigurationAggregatorMarshaller INSTANCE = new ConfigurationAggregatorMarshaller();

    private ConfigurationAggregatorMarshaller() {
    }

    public static ConfigurationAggregatorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigurationAggregator configurationAggregator, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configurationAggregator, (String)"configurationAggregator");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configurationAggregator.configurationAggregatorName(), CONFIGURATIONAGGREGATORNAME_BINDING);
            protocolMarshaller.marshall((Object)configurationAggregator.configurationAggregatorArn(), CONFIGURATIONAGGREGATORARN_BINDING);
            protocolMarshaller.marshall(configurationAggregator.accountAggregationSources(), ACCOUNTAGGREGATIONSOURCES_BINDING);
            protocolMarshaller.marshall((Object)configurationAggregator.organizationAggregationSource(), ORGANIZATIONAGGREGATIONSOURCE_BINDING);
            protocolMarshaller.marshall((Object)configurationAggregator.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)configurationAggregator.lastUpdatedTime(), LASTUPDATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

