/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.model.BaseConfigurationItem;

public class BaseConfigurationItemUnmarshaller
implements Unmarshaller<BaseConfigurationItem, JsonUnmarshallerContext> {
    private static final BaseConfigurationItemUnmarshaller INSTANCE = new BaseConfigurationItemUnmarshaller();

    public BaseConfigurationItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        BaseConfigurationItem.Builder baseConfigurationItemBuilder = BaseConfigurationItem.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.version((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("accountId", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.accountId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("configurationItemCaptureTime", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.configurationItemCaptureTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("configurationItemStatus", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.configurationItemStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("configurationStateId", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.configurationStateId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceId", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.resourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceName", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.resourceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsRegion", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.awsRegion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.availabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceCreationTime", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.resourceCreationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("configuration", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.configuration((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("supplementaryConfiguration", targetDepth)) {
                    context.nextToken();
                    baseConfigurationItemBuilder.supplementaryConfiguration(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BaseConfigurationItem)baseConfigurationItemBuilder.build();
    }

    public static BaseConfigurationItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}

