/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.BaseConfigurationItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BaseConfigurationItemMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CONFIGURATIONITEMCAPTURETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemCaptureTime").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONITEMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemStatus").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONSTATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationStateId").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").isBinary(false).build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESOURCECREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceCreationTime").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").isBinary(false).build();
    private static final MarshallingInfo<Map> SUPPLEMENTARYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supplementaryConfiguration").isBinary(false).build();
    private static final BaseConfigurationItemMarshaller INSTANCE = new BaseConfigurationItemMarshaller();

    private BaseConfigurationItemMarshaller() {
    }

    public static BaseConfigurationItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BaseConfigurationItem baseConfigurationItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)baseConfigurationItem, (String)"baseConfigurationItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)baseConfigurationItem.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.configurationItemCaptureTime(), CONFIGURATIONITEMCAPTURETIME_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.configurationItemStatusAsString(), CONFIGURATIONITEMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.configurationStateId(), CONFIGURATIONSTATEID_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.resourceCreationTime(), RESOURCECREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)baseConfigurationItem.configuration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.supplementaryConfiguration(), SUPPLEMENTARYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

