/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ComplianceResourceTypesCopier;
import software.amazon.awssdk.services.config.transform.ScopeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Scope
implements StructuredPojo,
ToCopyableBuilder<Builder, Scope> {
    private final List<String> complianceResourceTypes;
    private final String tagKey;
    private final String tagValue;
    private final String complianceResourceId;

    private Scope(BuilderImpl builder) {
        this.complianceResourceTypes = builder.complianceResourceTypes;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.complianceResourceId = builder.complianceResourceId;
    }

    public List<String> complianceResourceTypes() {
        return this.complianceResourceTypes;
    }

    public String tagKey() {
        return this.tagKey;
    }

    public String tagValue() {
        return this.tagValue;
    }

    public String complianceResourceId() {
        return this.complianceResourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceResourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceResourceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)obj;
        return Objects.equals(this.complianceResourceTypes(), other.complianceResourceTypes()) && Objects.equals(this.tagKey(), other.tagKey()) && Objects.equals(this.tagValue(), other.tagValue()) && Objects.equals(this.complianceResourceId(), other.complianceResourceId());
    }

    public String toString() {
        return ToString.builder((String)"Scope").add("ComplianceResourceTypes", this.complianceResourceTypes()).add("TagKey", (Object)this.tagKey()).add("TagValue", (Object)this.tagValue()).add("ComplianceResourceId", (Object)this.complianceResourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.complianceResourceTypes()));
            }
            case "TagKey": {
                return Optional.ofNullable(clazz.cast(this.tagKey()));
            }
            case "TagValue": {
                return Optional.ofNullable(clazz.cast(this.tagValue()));
            }
            case "ComplianceResourceId": {
                return Optional.ofNullable(clazz.cast(this.complianceResourceId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScopeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> complianceResourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String tagKey;
        private String tagValue;
        private String complianceResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(Scope model) {
            this.complianceResourceTypes(model.complianceResourceTypes);
            this.tagKey(model.tagKey);
            this.tagValue(model.tagValue);
            this.complianceResourceId(model.complianceResourceId);
        }

        public final Collection<String> getComplianceResourceTypes() {
            return this.complianceResourceTypes;
        }

        @Override
        public final Builder complianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ComplianceResourceTypesCopier.copy(complianceResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceResourceTypes(String ... complianceResourceTypes) {
            this.complianceResourceTypes(Arrays.asList(complianceResourceTypes));
            return this;
        }

        public final void setComplianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ComplianceResourceTypesCopier.copy(complianceResourceTypes);
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getTagValue() {
            return this.tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        public final String getComplianceResourceId() {
            return this.complianceResourceId;
        }

        @Override
        public final Builder complianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
            return this;
        }

        public final void setComplianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
        }

        public Scope build() {
            return new Scope(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Scope> {
        public Builder complianceResourceTypes(Collection<String> var1);

        public Builder complianceResourceTypes(String ... var1);

        public Builder tagKey(String var1);

        public Builder tagValue(String var1);

        public Builder complianceResourceId(String var1);
    }
}

