/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatus;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatusListCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationAggregatorSourcesStatusResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationAggregatorSourcesStatusResponse> {
    private final List<AggregatedSourceStatus> aggregatedSourceStatusList;
    private final String nextToken;

    private DescribeConfigurationAggregatorSourcesStatusResponse(BuilderImpl builder) {
        super(builder);
        this.aggregatedSourceStatusList = builder.aggregatedSourceStatusList;
        this.nextToken = builder.nextToken;
    }

    public List<AggregatedSourceStatus> aggregatedSourceStatusList() {
        return this.aggregatedSourceStatusList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatedSourceStatusList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorSourcesStatusResponse)) {
            return false;
        }
        DescribeConfigurationAggregatorSourcesStatusResponse other = (DescribeConfigurationAggregatorSourcesStatusResponse)((Object)obj);
        return Objects.equals(this.aggregatedSourceStatusList(), other.aggregatedSourceStatusList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationAggregatorSourcesStatusResponse").add("AggregatedSourceStatusList", this.aggregatedSourceStatusList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregatedSourceStatusList": {
                return Optional.ofNullable(clazz.cast(this.aggregatedSourceStatusList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<AggregatedSourceStatus> aggregatedSourceStatusList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorSourcesStatusResponse model) {
            super(model);
            this.aggregatedSourceStatusList(model.aggregatedSourceStatusList);
            this.nextToken(model.nextToken);
        }

        public final Collection<AggregatedSourceStatus.Builder> getAggregatedSourceStatusList() {
            return this.aggregatedSourceStatusList != null ? (Collection)this.aggregatedSourceStatusList.stream().map(AggregatedSourceStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregatedSourceStatusList(Collection<AggregatedSourceStatus> aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList = AggregatedSourceStatusListCopier.copy(aggregatedSourceStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedSourceStatusList(AggregatedSourceStatus ... aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList(Arrays.asList(aggregatedSourceStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedSourceStatusList(Consumer<AggregatedSourceStatus.Builder> ... aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList(Stream.of(aggregatedSourceStatusList).map(c -> (AggregatedSourceStatus)((AggregatedSourceStatus.Builder)AggregatedSourceStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregatedSourceStatusList(Collection<AggregatedSourceStatus.BuilderImpl> aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList = AggregatedSourceStatusListCopier.copyFromBuilder(aggregatedSourceStatusList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigurationAggregatorSourcesStatusResponse build() {
            return new DescribeConfigurationAggregatorSourcesStatusResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, DescribeConfigurationAggregatorSourcesStatusResponse> {
        public Builder aggregatedSourceStatusList(Collection<AggregatedSourceStatus> var1);

        public Builder aggregatedSourceStatusList(AggregatedSourceStatus ... var1);

        public Builder aggregatedSourceStatusList(Consumer<AggregatedSourceStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

