/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregationAuthorization;
import software.amazon.awssdk.services.config.model.AggregationAuthorizationListCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAggregationAuthorizationsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeAggregationAuthorizationsResponse> {
    private final List<AggregationAuthorization> aggregationAuthorizations;
    private final String nextToken;

    private DescribeAggregationAuthorizationsResponse(BuilderImpl builder) {
        super(builder);
        this.aggregationAuthorizations = builder.aggregationAuthorizations;
        this.nextToken = builder.nextToken;
    }

    public List<AggregationAuthorization> aggregationAuthorizations() {
        return this.aggregationAuthorizations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAuthorizations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAggregationAuthorizationsResponse)) {
            return false;
        }
        DescribeAggregationAuthorizationsResponse other = (DescribeAggregationAuthorizationsResponse)((Object)obj);
        return Objects.equals(this.aggregationAuthorizations(), other.aggregationAuthorizations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAggregationAuthorizationsResponse").add("AggregationAuthorizations", this.aggregationAuthorizations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregationAuthorizations": {
                return Optional.ofNullable(clazz.cast(this.aggregationAuthorizations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<AggregationAuthorization> aggregationAuthorizations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAggregationAuthorizationsResponse model) {
            super(model);
            this.aggregationAuthorizations(model.aggregationAuthorizations);
            this.nextToken(model.nextToken);
        }

        public final Collection<AggregationAuthorization.Builder> getAggregationAuthorizations() {
            return this.aggregationAuthorizations != null ? (Collection)this.aggregationAuthorizations.stream().map(AggregationAuthorization::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregationAuthorizations(Collection<AggregationAuthorization> aggregationAuthorizations) {
            this.aggregationAuthorizations = AggregationAuthorizationListCopier.copy(aggregationAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationAuthorizations(AggregationAuthorization ... aggregationAuthorizations) {
            this.aggregationAuthorizations(Arrays.asList(aggregationAuthorizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationAuthorizations(Consumer<AggregationAuthorization.Builder> ... aggregationAuthorizations) {
            this.aggregationAuthorizations(Stream.of(aggregationAuthorizations).map(c -> (AggregationAuthorization)((AggregationAuthorization.Builder)AggregationAuthorization.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregationAuthorizations(Collection<AggregationAuthorization.BuilderImpl> aggregationAuthorizations) {
            this.aggregationAuthorizations = AggregationAuthorizationListCopier.copyFromBuilder(aggregationAuthorizations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAggregationAuthorizationsResponse build() {
            return new DescribeAggregationAuthorizationsResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, DescribeAggregationAuthorizationsResponse> {
        public Builder aggregationAuthorizations(Collection<AggregationAuthorization> var1);

        public Builder aggregationAuthorizations(AggregationAuthorization ... var1);

        public Builder aggregationAuthorizations(Consumer<AggregationAuthorization.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

