/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePendingAggregationRequestRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DeletePendingAggregationRequestRequest> {
    private final String requesterAccountId;
    private final String requesterAwsRegion;

    private DeletePendingAggregationRequestRequest(BuilderImpl builder) {
        super(builder);
        this.requesterAccountId = builder.requesterAccountId;
        this.requesterAwsRegion = builder.requesterAwsRegion;
    }

    public String requesterAccountId() {
        return this.requesterAccountId;
    }

    public String requesterAwsRegion() {
        return this.requesterAwsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAwsRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePendingAggregationRequestRequest)) {
            return false;
        }
        DeletePendingAggregationRequestRequest other = (DeletePendingAggregationRequestRequest)((Object)obj);
        return Objects.equals(this.requesterAccountId(), other.requesterAccountId()) && Objects.equals(this.requesterAwsRegion(), other.requesterAwsRegion());
    }

    public String toString() {
        return ToString.builder((String)"DeletePendingAggregationRequestRequest").add("RequesterAccountId", (Object)this.requesterAccountId()).add("RequesterAwsRegion", (Object)this.requesterAwsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequesterAccountId": {
                return Optional.ofNullable(clazz.cast(this.requesterAccountId()));
            }
            case "RequesterAwsRegion": {
                return Optional.ofNullable(clazz.cast(this.requesterAwsRegion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String requesterAccountId;
        private String requesterAwsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePendingAggregationRequestRequest model) {
            super(model);
            this.requesterAccountId(model.requesterAccountId);
            this.requesterAwsRegion(model.requesterAwsRegion);
        }

        public final String getRequesterAccountId() {
            return this.requesterAccountId;
        }

        @Override
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        public final String getRequesterAwsRegion() {
            return this.requesterAwsRegion;
        }

        @Override
        public final Builder requesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
            return this;
        }

        public final void setRequesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePendingAggregationRequestRequest build() {
            return new DeletePendingAggregationRequestRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, DeletePendingAggregationRequestRequest> {
        public Builder requesterAccountId(String var1);

        public Builder requesterAwsRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

